% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differential_editing.R
\name{find_scde_sites}
\alias{find_scde_sites}
\title{Identify sites with differential editing between cells in single cell
datasets}
\usage{
find_scde_sites(sce, group, rowData = FALSE, BPPARAM = SerialParam(), ...)
}
\arguments{
\item{sce}{\link{SingleCellExperiment} object with \code{nRef} and \code{nAlt} assays.}

\item{group}{column name from colData used to define groups to compare.}

\item{rowData}{if TRUE,  \link{rowData} from the input \link{SingleCellExperiment} will
be included in the output DataFrames}

\item{BPPARAM}{BiocParallel backend for control how parallel computations
are performed.}

\item{...}{Additional arguments passed to \link[scran:combineMarkers]{scran::combineMarkers}}
}
\value{
A named list of \link{DataFrame}s containing results for each cluster specified by
\code{group}. The difference in editing frequencies between cluster pairs are
denoted as \code{dEF}. See \link[scran:combineMarkers]{scran::combineMarkers} for a description of additional
output fields.
}
\description{
Compare editing frequencies between clusters or celltypes. REF and ALT counts
from each cluster are pooled to create pseudobulk estimates. Each pair of
clusters are compared using fisher exact tests. Statistics are aggregated
across each pairwise
comparison using \link[scran:combineMarkers]{scran::combineMarkers}.
}
\examples{

### generate example data ###

library(Rsamtools)
library(GenomicRanges)
bam_fn <- raer_example("5k_neuron_mouse_possort.bam")

gr <- GRanges(c("2:579:-", "2:625:-", "2:645:-", "2:589:-", "2:601:-"))
gr$REF <- c(rep("A", 4), "T")
gr$ALT <- c(rep("G", 4), "C")

cbs <- unique(scanBam(bam_fn, param = ScanBamParam(tag = "CB"))[[1]]$tag$CB)
cbs <- na.omit(cbs)

outdir <- tempdir()
bai <- indexBam(bam_fn)

fp <- FilterParam(library_type = "fr-second-strand")
sce <- pileup_cells(bam_fn, gr, cbs, outdir, param = fp)

# mock some clusters
set.seed(42)
sce$clusters <- paste0("cluster_", sample(1:3, ncol(sce), replace = TRUE))
res <- find_scde_sites(sce, "clusters")
res[[1]]
}
