% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{find_mispriming_sites}
\alias{find_mispriming_sites}
\title{Find regions with oligodT mispriming}
\usage{
find_mispriming_sites(
  bamfile,
  fasta,
  pos_5p = 5,
  pos_3p = 20,
  min_reads = 2,
  tag = "pa",
  tag_values = 3:300,
  n_reads_per_chunk = 1e+06,
  verbose = TRUE
)
}
\arguments{
\item{bamfile}{path to bamfile}

\item{fasta}{path to fasta file}

\item{pos_5p}{distance 5' of mispriming site to define mispriming region}

\item{pos_3p}{distance 3' of mispriming site to define mispriming region}

\item{min_reads}{minimum required number of reads at a mispriming site}

\item{tag}{bam tag containing number of poly(A) bases trimmed}

\item{tag_values}{range of values required for read to be considered}

\item{n_reads_per_chunk}{number of reads to process in memory, see
\code{\link[Rsamtools:BamFile-class]{Rsamtools::BamFile()}}}

\item{verbose}{if true report progress}
}
\value{
A GenomicsRanges containing regions enriched for putative mispriming
events. The \code{n_reads} column specifies the number of polyA trimmed reads
overlapping the mispriming region. \code{mean_pal} indicates the mean length of
polyA sequence trimmed from reads overlapping the region. The \code{n_regions}
column specifies the number overlapping independent regions found in each
chunk (dictated by \code{n_reads_per_chunk}). The \code{A_freq} column indicates the
frequency of A bases within the region.
}
\description{
OligodT will prime at A-rich regions in an RNA. Reverse
transcription from these internal priming sites will install an oligodT
sequence at the 3' end of the cDNA. Sequence variants within these internal
priming sites are enriched for variants converting the genomic sequence to
the A encoded by the oligodT primer. Trimming poly(A) from the 3' ends of
reads reduces but does not eliminate these signals

This function will identify regions that are enriched for mispriming events.
Reads that were trimmed to remove poly(A) (encoded in the pa tag by
10x Genomics) are identified. The aligned 3' positions of these reads are
counted, and sites passing thresholds (at least 2 reads) are retained as
possible sites of mispriming. Be default regions 5 bases upstream and
20 bases downstream of these putative mispriming sites
are returned.
}
\examples{
bam_fn <- raer_example("5k_neuron_mouse_possort.bam")
fa_fn <- raer_example("mouse_tiny.fasta")
find_mispriming_sites(bam_fn, fa_fn)

}
