% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differential_editing.R
\name{find_de_sites}
\alias{find_de_sites}
\title{Perform differential editing}
\usage{
find_de_sites(
  deobj,
  test = c("edgeR", "DESeq2"),
  sample_col = "sample",
  condition_col = "condition",
  condition_control = NULL,
  condition_treatment = NULL
)
}
\arguments{
\item{deobj}{A \link{RangedSummarizedExperiment} object prepared for differential
editing analysis by \code{\link[=make_de_object]{make_de_object()}}}

\item{test}{Indicate if \code{edgeR} or \code{DESeq2} should be run.}

\item{sample_col}{The name of the column from \code{colData(deobj)} that
contains your sample information. Default is sample. If you do not have a
column named "sample", you must provide the appropriate sample column}

\item{condition_col}{The name of the column from \code{colData(deobj)} that
contains your treatment information. Default is condition, If you do not
have a column named "condition", you must provide the appropriate condition
column}

\item{condition_control}{The name of the control condition. This must be a
variable in your \code{condition_col} of \code{colData(deobj)}. No default provided.}

\item{condition_treatment}{The name of the treatment condition. This must be
a variable in your \code{condition_col} of \code{colData(deobj)}.}
}
\value{
A named list:
\itemize{
\item \code{de_obj}: The \code{edgeR} or \code{deseq} object used for differential editing
analysis
\item \code{results_full}: Unfiltered differential editing results
\item \code{sig_results}: Filtered differential editing (FDR < 0.05)
\item \code{model_matrix}: The model matrix used for generating DE results
}
}
\description{
Use \code{edgeR} or \code{DESeq2} to perform differential editing
analysis. This will work for designs that have 1 treatment and 1
control group. For more complex designs, we suggest you perform your own
modeling.
}
\examples{
library(SummarizedExperiment)
bamfn <- raer_example("SRR5564269_Aligned.sortedByCoord.out.md.bam")
bam2fn <- raer_example("SRR5564277_Aligned.sortedByCoord.out.md.bam")
fafn <- raer_example("human.fasta")

bams <- rep(c(bamfn, bam2fn), each = 3)
sample_ids <- paste0(rep(c("KO", "WT"), each = 3), 1:3)
names(bams) <- sample_ids

fp <- FilterParam(only_keep_variants = TRUE)
rse <- pileup_sites(bams, fafn, param = fp)
rse$condition <- substr(rse$sample, 1, 2)

rse <- calc_edit_frequency(rse)
dse <- make_de_object(rse)
res <- find_de_sites(dse,
    condition_control = "WT",
    condition_treatment = "KO"
)
res$sig_results[1:3, ]

}
