SW.checkORTHBASE <- function(orth, input) { # SweeP
    
  if(!is.matrix(orth)){
      stop("Orthbase must be an array generated by the `orthBase' function. See ?orthBase")
  }else if(dim(orth)[1] != dim(input)[2]){
      stop("The number of rows of the orthbase matrix must be equal to the number of features of the input data. See ?orthBase")
  }
}

##------------------------------------------------------------------------
##This function is used for argument checking
SW.checks <- function(name, param) {

  if(name=="seqtype"){ #[]
    opts<-c("AA","NT")
    if(!is.character(param) || length(param)!=1 || !(param %in% opts))
      stop(paste("'seqtype' should be any one of the options: \n", 
                 paste(opts,collapse = ", ") ) ,call.=FALSE)
  } 
  else if(name=="extension"){ #[]
    if(!is.character(param))
      stop("'extension' should be a character or a list of characters.\n",call.=FALSE)
  } 
  else if(name=="psz"){ #[]
    if(!is.numeric(param) || (param-floor(param))!=0 )
      stop("'psz' should be a integer numeric value.\n",call.=FALSE)
  } 
  else if(name=="mask"){ #[]
    if(!is.numeric(param))
      stop("'mask' should be a vector as: mask = c(2,1,2). See help of function.\n",call.=FALSE)
  } 
  else if(name=="bin"){ #[]
    if(!is.logical(param))
      stop("'bin' should be logical. TRUE for binary mode, FALSE for counting one. \n",call.=FALSE)
  } 
  else if(name=="readEachFASTA"){ #[]
    if(!is.logical(param))
      stop("'readEachFASTA' should be logical. TRUE to read one FASTA at a time, FALSE otherwise. \n",call.=FALSE)
  } 
  else if(name=="fastalist"){ #[]
    if(length(param)==0)
      stop("The folder provided does not seem to contain files with the extension provided, or it is empty. \n",call.=FALSE)
  } 
  else if(name=="RNAseqdata"){ #[]
    if(!is.logical(param))
      stop("'RNAseqdata' must be logical. TRUE to use RNAseq data if each row corresponds to a gene and each column corresponds to a sample. \n",call.=FALSE)
  } 
  else if(name=="transpose"){ #[]
    if(!is.logical(param))
      stop("'transpose' should be one of the options: TRUE - Seurat pattern wich each column is a sample; FALSE - each line is a sample. \n",call.=FALSE)
  }
  else if(name=="norm"){ #[]
    if(param!='none' & param!='log' & param!='logNeg' & param!='Neg')
      stop("'norm' must be one of the following options: `none` for none of normalization options, `log` for logarithm, `Neg` for conversion of nulls to -1 or `logNeg` for logarithm and conversion of nulls to -1. \n",call.=FALSE)
  }
  else if(name=="concatenate"){ #[]
    if(!is.logical(param))
      stop("'concatenate' should be logical. TRUE to concatenate the sequences in one single, FALSE otherwise. \n",call.=FALSE)
} 
  
}
