% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tracks.R
\name{track_narrow_peak}
\alias{track_narrow_peak}
\title{Generate narrow peaks track}
\usage{
track_narrow_peak(
  file,
  title = NULL,
  height = 3,
  overlay_previous = "no",
  orientation = NULL,
  line_width = 1,
  color = "#FF000080",
  max_value = NULL,
  show_data_range = TRUE,
  show_labels = TRUE,
  use_summit = TRUE,
  width_adjust = 1.5,
  type = "peak"
)
}
\arguments{
\item{file}{String. The location of the track file}

\item{title}{String. If specificed, the title of the track to be displayed.}

\item{height}{Numeric. The height of the plotted track in cm. Default is 2.
See notes.}

\item{overlay_previous}{String. Options are "no" (default) or "yes" or
"share-y".}

\item{orientation}{String. Default is NULL. Other option is "inverted".}

\item{line_width}{Numeric value for line width.}

\item{color}{String. Hex color or string color. Default is "#1f78b4".}

\item{max_value}{Numeric. Default is NULL. The max value cut-off for the
numeric column.}

\item{show_data_range}{Boolean. Default is TRUE.}

\item{show_labels}{Boolean. If TRUE, display labels on plotting which include peak tag, p-val and q-val.}

\item{use_summit}{Boolean. If TRUE, peak summit data will be plotted.}

\item{width_adjust}{Numeric value above 0 to adjust peaks' width. Default is 1.5.}

\item{type}{String with options either "peak" or "box".}
}
\value{
genome_track
}
\description{
Create genome_track object from narrow peak bed format.
}
\details{
narrowPeak file is bed file (4+3), where the 5th column is peak name, 6th column in p-value and 7th column in q-value. You might increase height it increased font size.
narrowPeak format is very common with analysis pipelines involving MACS2.
narrowPeak format provides the information of the peak summit.
use_summit argument is used to deterimine if this information should be used.
By default this information is used (use_summit = TRUE) although some peaks may look crooked.
type argument specify if the plot will be:
\itemize{
\item{"box" which will plot a rectangle of the peak width}
\item{or "peak" which will plot the shape of the peak, whose height is the
narrowPeak file signal value (usually peak coverage) }
}
}
\examples{
np_bed_dir <- system.file("extdata", "test2.narrowPeak", package = "rGenomeTracks")

tracks <-
  track_scalebar() +
  track_narrow_peak(np_bed_dir,
    title = "peak type with summit",
    height = 3,
    type = "peak",
    color = "green"
  ) +

  track_spacer(height = 2) +
  track_narrow_peak(np_bed_dir,
    title = "peak type without summit",
    height = 3,
    type = "peak",
    color = "green",
    use_summit = FALSE
  ) +
  track_spacer(height = 2) +
  track_narrow_peak(np_bed_dir,
    title = "Box type with summit",
    height = 3,
    type = "box",
    color = "blue"
  ) +
  track_spacer(height = 2) +
  track_narrow_peak(np_bed_dir,
    title = "Box type without summit",
    height = 3,
    type = "box",
    color = "blue",
    use_summit = FALSE
  ) +
  track_x_axis()
\dontrun{
plot_gtracks(tracks, chr = "X", start = 276 * 10^4, end = 280 * 10^4, trackLabelFraction = 0.2)
}
}
\author{
Omar Elashkar
}
