% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeBiopax.R
\name{writeBiopax}
\alias{writeBiopax}
\title{This function writes out a biopax model.}
\usage{
writeBiopax(
  biopax,
  file = "",
  verbose = TRUE,
  overwrite = FALSE,
  namespaces = list(rdf = "http://www.w3.org/1999/02/22-rdf-syntax-ns#", bp =
    "http://www.biopax.org/release/biopax-level2.owl#", rdfs =
    "http://www.w3.org/2000/01/rdf-schema#", owl = "http://www.w3.org/2002/07/owl#", xsd
    = "http://www.w3.org/2001/XMLSchema#")
)
}
\arguments{
\item{biopax}{A biopax model as generated by readBiopax}

\item{file}{A string giving a file name.}

\item{verbose}{logical}

\item{overwrite}{logical, if TRUE an already existing file will be overwritten, otherwise an error is thrown}

\item{namespaces}{A list of namespaces to use for the generated XML/RDF file}
}
\value{
Returns the xmlTree object generated from the biopax model. If a filename is supplied the XML is written to this file.
}
\description{
This function writes out a biopax model, as generated by readBiopax, to either a file or returns the xmlTree if file is omitted.
}
\examples{
 # load data
 data(biopax2example)
 \dontrun{writeBiopax(biopax, file="mybiopax.owl")}
}
\author{
Frank Kramer
}
