\name{r3Cseq-class}
\docType{class}

% Classes:
\alias{r3Cseq}
\alias{r3Cseq-class}

\title{r3Cseq objects}

\description{
  The r3Cseq class is the extended class from r3CseqCommon class. It is a general container for storing
  and manipulating a set of input parameters, RangeData of interactions regions from r3Cseq analysis
  , and the raw reads GRanged data of the genome-wide interaction signal generated by next-generation sequencing. 
}
\section{Extends}{
Class \code{r3CseqCommon}, directly.
}

\section{Slots}{
  \describe{
  
      \item{\code{organismName}}{Object of class \code{"character"} the version of 
      particular assembly genome from UCSC (e.g. mm9, hg18, hg19) . The package supports
      three genome assemblies consisting of mouse (mm9), and human (hg18, hg19).}

    \item{\code{restrictionEnzyme}}{Object of class \code{"character"} this is the primary
      restriction enzyme name using in 3C-Seq experiment}

    \item{\code{viewpoint_chromosome}}{Object of class \code{"character"} 
    	chromosome name of where is the viewpoint located eg. chr10, chrX etc.
     }
    \item{\code{viewpoint_primer_forward}}{Object of class \code{"character"}
      the forward primer DNA sequences for the viewpoint amplification}
      
    \item{\code{viewpoint_primer_reverse}}{Object of class \code{"character"}
      the reverse primer DNA sequences for the viewpoint amplification}
    
    \item{\code{expReadCount}}{Object of class \code{"RangedData"}
      the read count in experiment}  
    
    \item{\code{contrReadCount}}{Object of class \code{"RangedData"}
      the read count in control}  
    
    \item{\code{expRPM}}{Object of class \code{"RangedData"}
      the normalized read read per million in experiment}  
   
    \item{\code{contrRPM}}{Object of class \code{"RangedData"}
      the normalized read read per million in control}  
   
    \item{\code{expInteractionRegions}}{Object of class \code{"RangedData"}
      the identified interaction regions in experiment}  
   
    \item{\code{contrInteractionRegions}}{Object of class \code{"RangedData"}
      the identified interaction regions in control}  
      
 	\item{\code{isControlInvolved}}{Object of class \code{"logical"}
      the logical to ask whether the control is involved in the analysis or not}
  
    \item{\code{alignedReadsBamExpFile}}{Object of class \code{"character"}
      the file name of experiment in BAM format}
      
    \item{\code{alignedReadsBamContrFile}}{Object of class \code{"character"}
      the file name of control in BAM format}
        
    \item{\code{expLabel}}{Object of class \code{"character"}
      the experiment name}
      
    \item{\code{contrLabel}}{Object of class \code{"character"}
      the control name}
    
    \item{\code{expLibrarySize }}{Object of class \code{"integer"}
      the library size of experiment}  
      
    \item{\code{contrLibrarySize }}{Object of class \code{"integer"}
      the library size of control}  
    
    \item{\code{expReadLength}}{Object of class \code{"integer"}
      the read length of experiment}  
      
    \item{\code{contrReadLength}}{Object of class \code{"integer"}
      the read length of experiment} 
    
    \item{\code{expRawData}}{Object of class \code{"GRanges"}
      the raw reads found in experiment}  
    
    \item{\code{contrRawData}}{Object of class \code{"GRanges"}
      the raw reads found in control}  
  }
}

\author{S. Thongjuea}

\seealso{
  \link{r3CseqCommon},
  \link{r3CseqInBatch}
}
\examples{
# See the vignette
}

\keyword{classes}
