% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removeFeatures-functions.R
\name{removeBlankRatio}
\alias{removeBlankRatio}
\title{Feature Filtering based on QC/blank ratio}
\usage{
removeBlankRatio(
  x,
  blank_samples,
  qc_samples,
  cut = 2,
  type = c("median", "mean"),
  blank_min_n = 3
)
}
\arguments{
\item{x}{A matrix-like object.}

\item{blank_samples}{A vector of sample names or column indices specifying
blank samples for the calculation of ratio. Must be a subset of
\code{colnames(x)} if it is a character vector.}

\item{qc_samples}{A vector of sample names or column indices specifying QC
samples for the calculation of ratio. Must be a subset of
\code{colnames(x)} if it is a character vector.}

\item{cut}{A numeric value greater than 1 specifying a QC/blank ratio
cut-off to retain a feature.}

\item{type}{A method to compute a QC/blank ratio. Either "median" or
"mean".}

\item{blank_min_n}{An integer value specifying the minimum number of blank
samples to calculate a ratio.}
}
\value{
A matrix containing the filtered features.
}
\description{
Removes Features with based on QC/blank ratios using the data matrix where
rows represent features and columns represent samples. A feature will be
retained if there are not enough blank samples to calculate an intensity
ratio for a feature (or completely absent in blank samples). Use
\link{removeMiss} to remove features based on a proportion of missing values.
Features with a QC/blank ratio below a cut-off will be discarded.
}
\examples{
set.seed(1e7)

m_blank <- matrix(rlnorm(200), ncol = 5)
m_qc <- matrix(rlnorm(400, 1), ncol = 10)
m <- cbind(m_blank, m_qc)
colnames(m) <- c(paste0("B", seq_len(5)), paste0("Q", seq_len(10)))

removeBlankRatio(m, blank_samples = paste0("B", seq_len(5)),
                 qc_samples = paste0("Q", seq_len(10)))

}
\seealso{
See \link{removeFeatures} that provides a
\linkS4class{SummarizedExperiment}-friendly wrapper for this function.
}
