% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imputeIntensity-methods.R
\name{imputeIntensity}
\alias{imputeIntensity}
\alias{imputeIntensity,ANY-method}
\alias{imputeIntensity,SummarizedExperiment-method}
\title{Imputation methods}
\usage{
\S4method{imputeIntensity}{ANY}(
  x,
  method = c("knn", "rf", "bpca", "QRILC", "MLE", "MinDet", "MinProb", "min", "zero",
    "mixed", "nbavg", "with", "none"),
  ...
)

\S4method{imputeIntensity}{SummarizedExperiment}(
  x,
  method = c("knn", "rf", "bpca", "QRILC", "MLE", "MinDet", "MinProb", "min", "zero",
    "mixed", "nbavg", "with", "none"),
  i,
  name,
  ...
)
}
\arguments{
\item{x}{A matrix-like object or \linkS4class{SummarizedExperiment} object.}

\item{method}{A string specifying which imputation method to use.}

\item{...}{Arguments passed to a specific imputation method.}

\item{i}{A string or integer value specifying which assay values to use
when \code{x} is a SummarizedExperiment object.}

\item{name}{A string specifying the name to be used to store the imputed
intensities in \code{x} when \code{x} is a SummarizedExperiment object. If
not specified, a matrix containing the imputed intensities is returned.}
}
\value{
A matrix or \linkS4class{SummarizedExperiment} object of the same
dimension as \code{x} containing the imputed intensities.
}
\description{
Performs a variety of data imputation methods on a matrix-like object or
\linkS4class{SummarizedExperiment} object. The methods include k-Nearest
Neighbors (kNN), Random Forest (RF), and many others from the
\link[MsCoreUtils:imputation]{MsCoreUtils::impute_matrix}. See the details below.
}
\details{
The method argument can be one of "knn", "rf", "bpca", "QRILC", "MLE",
"MinDet", "MinProb", "min", "zero", "mixed", "nbavg", "with", "none". Please
choose one that best describes the nature of missing data. While this
function provides several simple imputation methods, they may only work
under restrictive assumptions.
\itemize{
\item "knn" performs kNN imputation based on the Gower distance or Euclidean
distance. See \link{imputeKNN} for details.
\item "rf" performs random forest imputation using the \link[missForest:missForest]{missForest::missForest},
as described in Stekhoven D. J., & Buehlmann, P. (2012). This method is not
sensitive to monotonic transformations of the intensity matrix.
\item For the other method arguments, please refer to the
\link[MsCoreUtils:imputation]{MsCoreUtils::impute_matrix}. Briefly,
\itemize{
\item "bpca": Bayesian PCA missing value imputation.
\item "QRILC": Quantile regression approach for the imputation of
left-censored missing data.
\item "MLE": Maximum likelihood-based imputation.
\item "MinDet": Deterministic minimal value approach for the imputation of
left-censored data.
\item "MinProb": Stochastic minimal value approach for the imputation of
left-censored data.
\item "min": Replace the missing values with the smallest non-missing value in
the data.
\item "zero": Replace the missing values with 0.
\item "mixed": Mixed imputation applying two methods.
\item "nbavg": Average neighbour imputation for fractions collected along a
fractionation/separation gradient.
\item "with": Replace the missing values with a user-provided value.
\item "none": Reserved for the "mixed" method.
}
}
}
\examples{

data(faahko_se)

## SummarizedExperiment object
se <- imputeIntensity(faahko_se, i = "raw", name = "imp1", method = "knn")
assayNames(se)

## Matrix
m <- assay(faahko_se, i = "raw")
imputeIntensity(m, method = "min")

}
\references{
Laurent Gatto, Johannes Rainer and Sebastian Gibb (2021).
MsCoreUtils: Core Utils for Mass Spectrometry Data. R package version
1.4.0. https://github.com/RforMassSpectrometry/MsCoreUtils

Stekhoven D. J., & Buehlmann, P. (2012). MissForest - non-parametric missing
value imputation for mixed-type data. Bioinformatics, 28(1), 112-118.
}
\seealso{
See \link{imputeKNN}, \link[missForest:missForest]{missForest::missForest}, and
\link[MsCoreUtils:imputation]{MsCoreUtils::impute_matrix} for the underlying functions that do work.
}
