% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_geNormalisationFiltering.R
\name{plotLibrarySize}
\alias{plotLibrarySize}
\title{Plot library size}
\usage{
plotLibrarySize(
  data,
  log10 = TRUE,
  title = "Library size distribution across samples",
  subtitle = "Library size: total number of mapped reads",
  colour = "orange"
)
}
\arguments{
\item{data}{Data frame or matrix: gene expression}

\item{log10}{Boolean: log10-transform \code{data}?}

\item{title}{Character: plot title}

\item{subtitle}{Character: plot subtitle}

\item{colour}{Character: data colour}
}
\value{
Library size distribution
}
\description{
Plot library size
}
\examples{
df <- data.frame(geneA=c(2, 4, 5),
                 geneB=c(20, 3, 5),
                 geneC=c(5, 10, 21))
colnames(df) <- paste("Sample", 1:3)
plotLibrarySize(df)
}
\seealso{
Other functions for gene expression pre-processing: 
\code{\link{convertGeneIdentifiers}()},
\code{\link{filterGeneExpr}()},
\code{\link{normaliseGeneExpression}()},
\code{\link{plotGeneExprPerSample}()},
\code{\link{plotRowStats}()}
}
\concept{functions for gene expression pre-processing}
