% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events_mats.R
\name{parseMatsEvent}
\alias{parseMatsEvent}
\title{Parse alternative splicing events from MATS}
\usage{
parseMatsEvent(event, event_type)
}
\arguments{
\item{event}{Data frame row: MATS splicing event}

\item{event_type}{Character: Type of event to parse (see details)}
}
\value{
List containing the event attributes and junctions
}
\description{
Parse alternative splicing events from MATS
}
\details{
The following event types can be parsed:
\itemize{
 \item{\strong{SE}: Skipped exon}
 \item{\strong{MXE}: Mutually exclusive exons}
 \item{\strong{RI}:Retained intron}
 \item{\strong{A3SS}: Alternative 3' splice site}
 \item{\strong{A5SS}: Alternative 5' splice site}
}
}
\examples{
# MATS event (alternative 3' splice site)
event <- read.table(text = "
     2 ENSG00000166012 TAF1D chr11 - 93466515 93466671 93466515 93466563 93467790 93467826
     5 ENSG00000166012 TAF1D chr11 - 93466515 93466671 93466515 93466585 93467790 93467826
     6 ENSG00000166012 TAF1D chr11 - 93466515 93466585 93466515 93466563 93467790 93467826
")
psichomics:::parseMatsEvent(event, "A3SS")
}
\keyword{internal}
