% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_recount.R
\name{loadSRAproject}
\alias{loadSRAproject}
\title{Download and load SRA projects via
\href{https://jhubiostatistics.shinyapps.io/recount/}{recount2}}
\usage{
loadSRAproject(project, outdir = getDownloadsFolder())
}
\arguments{
\item{project}{Character: SRA project identifiers (check
\code{\link[recount]{recount_abstract}})}

\item{outdir}{Character: directory to store the downloaded files}
}
\value{
List with loaded projects
}
\description{
Download and load SRA projects via
\href{https://jhubiostatistics.shinyapps.io/recount/}{recount2}
}
\examples{
\dontrun{
View(recount::recount_abstract)
sra <- loadSRAproject("SRP053101")
names(sra)
names(sra[[1]])
}
}
\seealso{
Other functions associated with SRA data retrieval: 
\code{\link{getDownloadsFolder}()}

Other functions to load data: 
\code{\link{loadGtexData}()},
\code{\link{loadLocalFiles}()},
\code{\link{loadTCGAdata}()}
}
\concept{functions associated with SRA data retrieval}
\concept{functions to load data}
