% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{filterGroups}
\alias{filterGroups}
\title{Filter groups with less data points than the threshold}
\usage{
filterGroups(vector, group, threshold = 1)
}
\arguments{
\item{vector}{Character: elements}

\item{group}{Character: respective group of each elements}

\item{threshold}{Integer: number of valid non-missing values by group}
}
\value{
Named vector with filtered elements from valid groups. The group of
the respective element is given as an attribute.
}
\description{
Groups containing a number of non-missing values less than the threshold are
discarded.
}
\examples{
# Removes groups with less than two elements
vec <- 1:6
names(vec) <- paste("sample", letters[1:6])
filterGroups(vec, c("A", "B", "B", "C", "D", "D"), threshold=2)
}
