% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_dimReduction_pca.R
\name{plotPCA}
\alias{plotPCA}
\title{Create a scatterplot from a PCA object}
\usage{
plotPCA(
  pca,
  pcX = 1,
  pcY = 2,
  groups = NULL,
  individuals = TRUE,
  loadings = FALSE,
  nLoadings = NULL
)
}
\arguments{
\item{pca}{\code{prcomp} object}

\item{pcX}{Character: name of the X axis of interest from the PCA}

\item{pcY}{Character: name of the Y axis of interest from the PCA}

\item{groups}{Matrix: groups to plot indicating the index of interest of the
samples (use clinical or sample groups)}

\item{individuals}{Boolean: plot PCA individuals}

\item{loadings}{Boolean: plot PCA loadings/rotations}

\item{nLoadings}{Integer: Number of variables to plot, ordered by those that
most contribute to selected principal components (this allows for faster
performance as only the most contributing variables are rendered); if
\code{NULL}, all variables are plotted}
}
\value{
Scatterplot as an \code{highchart} object
}
\description{
Create a scatterplot from a PCA object
}
\examples{
pca <- prcomp(USArrests, scale=TRUE)
plotPCA(pca)
plotPCA(pca, pcX=2, pcY=3)

# Plot both individuals and loadings
plotPCA(pca, pcX=2, pcY=3, loadings=TRUE)

# Only plot loadings
plotPCA(pca, pcX=2, pcY=3, loadings=TRUE, individuals=FALSE)
}
\seealso{
Other functions to analyse principal components: 
\code{\link{calculateLoadingsContribution}()},
\code{\link{performPCA}()},
\code{\link{plotPCAvariance}()}
}
\concept{functions to analyse principal components}
