% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_files_functions.R
\name{bg_correct}
\alias{bg_correct}
\title{bg_correct}
\usage{
bg_correct(iden, Data1, genepix_vars, method = "subtract_local")
}
\arguments{
\item{iden}{A character indicating the name of the object to be 
used under Data1}

\item{Data1}{A data frame with sample identifiers merged with micro 
array data.}

\item{genepix_vars}{A list of specific definitions of the experiment design.
See \code{\link{array_vars}}.}

\item{method}{a description of the background correction to be used. 
 Possible values are \code{"none","subtract_local",
"subtract_global","movingmin_bg","minimum_half","edwards" or "normexp"}. 
The default is \code{"subtract_local"}.}
}
\value{
A data frame with background corrected data
}
\description{
A generic function to perform background correction.
}
\details{
Background correction

 The function implements background correction methods developed 
by \code{\link[limma]{backgroundCorrect}}. But the
\code{minimum_half and movingmin_bg} uses the block of the protein array as
the grid. If method="movingmin_bg" the minimum
background value within a  block is subtracted.
If method="minimum_half" then any intensity which is negative after 
background subtraction is reset to be equal to half the 
minimum positive value in
a block.  If method="movingmin_value" then any intensity which is negative 
after background subtraction is reset to the minimum positive value
in a block. For \code{edwards} we implement a similar algorithm with 
\code{limma::backgroundCorrect(method="edwards")} and for \code{'normexp'}
we use  the saddle-point approximation to maximum likelihood, 
\code{\link[limma]{backgroundCorrect}} for more details.
}
