% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivariateAnalysisR.R
\name{multivariateAnalysisR}
\alias{multivariateAnalysisR}
\title{Generic multivariateAnalysisR function}
\usage{
multivariateAnalysisR(
  significanceLevel = 0.05,
  patternKeys,
  seuratobj,
  dictionaries,
  customNames = NULL,
  exclusive = TRUE,
  exportFolder = "",
  ANOVAwidth = 1000,
  ANOVAheight = 1000,
  CIwidth = 1000,
  CIheight = 1000,
  CIspacing = 1
)
}
\arguments{
\item{significanceLevel}{double value for testing significance in ANOVA test}

\item{patternKeys}{list of strings indicating pattern subsets from seuratobj to be analyzed}

\item{seuratobj}{Seurat Object Data containing patternKeys in meta.data}

\item{dictionaries}{list of dictionaries indicating clusters to be compared}

\item{customNames}{list of custom names for clusters in corresponding order}

\item{exclusive}{boolean value for determining interpolation between params in clusters}

\item{exportFolder}{name of folder to store exported graphs and CSV files}

\item{ANOVAwidth}{width of ANOVA png}

\item{ANOVAheight}{height of ANOVA png}

\item{CIwidth}{width of CI png}

\item{CIheight}{height of CI png}

\item{CIspacing}{spacing between each CI in CI graph}
}
\value{
a sorted list of ANOVA and CI results; ANOVA and Confidence Intervals are visualized and exported in both PNG and CSV
}
\description{
Performs multivariate analysis across specified clusters in datasets
}
