/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.readers;

import java.io.IOException;
import java.io.InputStream;
import org.apache.xerces.framework.XMLErrorReporter;
import org.apache.xerces.readers.AbstractCharReader;
import org.apache.xerces.readers.XMLEntityHandler;
import org.apache.xerces.utils.StringPool;

final class UTF8CharReader
extends AbstractCharReader {
    private InputStream fInputStream = null;
    private boolean fCheckOverflow = false;
    private byte[] fOverflow = null;
    private int fOverflowOffset = 0;
    private int fOverflowEnd = 0;
    private int fOutputOffset = 0;
    private boolean fSkipLinefeed = false;
    private int fPartialMultiByteIn = 0;
    private byte[] fPartialMultiByteChar = new byte[3];
    private int fPartialSurrogatePair = 0;
    private boolean fPartialMultiByteResult = false;

    UTF8CharReader(XMLEntityHandler xMLEntityHandler, XMLErrorReporter xMLErrorReporter, boolean bl, InputStream inputStream, StringPool stringPool) throws Exception {
        super(xMLEntityHandler, xMLErrorReporter, bl, stringPool);
        this.fInputStream = inputStream;
        this.fillCurrentChunk();
    }

    /*
     * Unable to fully structure code
     */
    protected int fillCurrentChunk() throws Exception {
        var1_1 = this.fCurrentChunk.toCharArray();
        this.fOutputOffset = 0;
        if (this.fCheckOverflow) {
            this.fMostRecentData = var1_1;
            if (this.fOverflowEnd < 16384) {
                var1_1 = null;
                if (this.fOverflowEnd > 0) {
                    if (this.fMostRecentData == null || this.fMostRecentData.length < 1 + this.fOverflowEnd - this.fOverflowOffset) {
                        this.fMostRecentData = new char[1 + this.fOverflowEnd - this.fOverflowOffset];
                    }
                    this.copyNormalize(this.fOverflow, this.fOverflowOffset, this.fMostRecentData, this.fOutputOffset);
                } else if (this.fMostRecentData == null) {
                    this.fMostRecentData = new char[1];
                }
                this.fMostRecentData[this.fOutputOffset] = '\u0000';
                this.fOverflow = null;
                this.fLength += this.fOutputOffset;
                this.fCurrentIndex = 0;
                this.fCurrentChunk.setCharArray(this.fMostRecentData);
                this.fMostRecentChar = this.fMostRecentData[0];
                return this.fMostRecentChar;
            }
            if (this.fMostRecentData == null || this.fMostRecentData.length < 16384) {
                this.fMostRecentData = new char[16384];
            } else {
                var1_1 = null;
            }
            this.copyNormalize(this.fOverflow, this.fOverflowOffset, this.fMostRecentData, this.fOutputOffset);
            this.fCheckOverflow = false;
        } else {
            if (this.fOverflow == null) {
                this.fOverflow = new byte[16384];
            }
            this.fMostRecentData = null;
        }
        do lbl-1000:
        // 3 sources

        {
            block22: {
                this.fOverflowOffset = 0;
                this.fOverflowEnd = 0;
                var2_2 = 16384;
                var3_3 = 0;
                do {
                    try {
                        var3_3 = this.fInputStream.read(this.fOverflow, this.fOverflowEnd, var2_2);
                    }
                    catch (IOException var4_4) {
                        var3_3 = -1;
                    }
                    if (var3_3 == -1) {
                        this.fInputStream.close();
                        this.fInputStream = null;
                        if (this.fMostRecentData == null) {
                            this.fMostRecentData = var1_1;
                            if (this.fMostRecentData == null || this.fMostRecentData.length < 1 + this.fOverflowEnd) {
                                this.fMostRecentData = new char[1 + this.fOverflowEnd];
                            } else {
                                var1_1 = null;
                            }
                            this.copyNormalize(this.fOverflow, this.fOverflowOffset, this.fMostRecentData, this.fOutputOffset);
                            this.fOverflow = null;
                            this.fMostRecentData[this.fOutputOffset] = '\u0000';
                            break;
                        }
                        var4_5 = this.copyNormalize(this.fOverflow, this.fOverflowOffset, this.fMostRecentData, this.fOutputOffset);
                        if (var4_5) {
                            if (this.fOverflowEnd == 16384) {
                                this.fCheckOverflow = true;
                                this.fOverflowOffset = 0;
                                this.fOverflowEnd = 0;
                                break;
                            }
                            this.fOverflow = null;
                            this.fMostRecentData[this.fOutputOffset] = '\u0000';
                            break;
                        }
                        this.fCheckOverflow = true;
                        break;
                    }
                    if (var3_3 <= 0) continue;
                    this.fOverflowEnd += var3_3;
                    var2_2 -= var3_3;
                } while (var2_2 > 0);
                if (var3_3 == -1) break;
                if (this.fMostRecentData == null) break block22;
                var4_6 = this.copyNormalize(this.fOverflow, this.fOverflowOffset, this.fMostRecentData, this.fOutputOffset);
                if (this.fOutputOffset != 16384) ** GOTO lbl-1000
                if (var4_6) break;
                this.fCheckOverflow = true;
                break;
            }
            this.fMostRecentData = var1_1;
            if (this.fMostRecentData == null || this.fMostRecentData.length < 16384) {
                this.fMostRecentData = new char[16384];
            } else {
                var1_1 = null;
            }
            this.copyNormalize(this.fOverflow, this.fOverflowOffset, this.fMostRecentData, this.fOutputOffset);
        } while (this.fOutputOffset != 16384);
        this.fLength += this.fOutputOffset;
        this.fCurrentIndex = 0;
        this.fCurrentChunk.setCharArray(this.fMostRecentData);
        this.fMostRecentChar = this.fMostRecentData[0];
        return this.fMostRecentChar;
    }

    private boolean copyNormalize(byte[] byArray, int n, char[] cArray, int n2) throws Exception {
        int n3 = this.fOverflowEnd;
        int n4 = cArray.length;
        if (n == n3) {
            return true;
        }
        byte by = byArray[n];
        if (this.fSkipLinefeed) {
            this.fSkipLinefeed = false;
            if (by == 10) {
                if (++n == n3) {
                    return this.exitNormalize(n, n2, true);
                }
                by = byArray[n];
            }
        } else if (this.fPartialMultiByteIn > 0) {
            if (!this.handlePartialMultiByteChar(by, byArray, n, n3, cArray, n2, n4)) {
                return this.fPartialMultiByteResult;
            }
            n = this.fOverflowOffset;
            n2 = this.fOutputOffset;
            by = byArray[n];
        }
        while (n2 < n4) {
            int n5 = n3 - n;
            int n6 = n4 - n2;
            if (n5 > n6) {
                n5 = n6;
            }
            ++n;
            while (true) {
                if (by == 13 || by < 0) {
                    if (by == 13) {
                        cArray[n2++] = 10;
                        if (n == n3) {
                            this.fSkipLinefeed = true;
                            return this.exitNormalize(n, n2, true);
                        }
                        by = byArray[n];
                        if (by == 10) {
                            if (++n == n3) {
                                return this.exitNormalize(n, n2, true);
                            }
                            by = byArray[n];
                        }
                        if (n2 == n4) {
                            return this.exitNormalize(n, n2, false);
                        }
                    } else {
                        if (!this.handleMultiByteChar(by, byArray, n, n3, cArray, n2, n4)) {
                            return this.fPartialMultiByteResult;
                        }
                        n = this.fOverflowOffset;
                        n2 = this.fOutputOffset;
                        by = byArray[n];
                    }
                    if ((n5 = n3 - n) > (n6 = n4 - n2)) {
                        n5 = n6;
                    }
                    ++n;
                    continue;
                }
                do {
                    cArray[n2++] = (char)by;
                } while (--n5 != 0 && (by = byArray[n++]) != 13 && by >= 0);
                if (n5 == 0) break;
            }
            if (n == n3) break;
        }
        return this.exitNormalize(n, n2, n == n3);
    }

    private boolean exitNormalize(int n, int n2, boolean bl) {
        this.fOverflowOffset = n;
        this.fOutputOffset = n2;
        return bl;
    }

    private void savePartialMultiByte(int n, byte by, byte by2, byte by3) {
        this.fPartialMultiByteIn = n--;
        this.fPartialMultiByteChar[n] = by;
        this.fPartialMultiByteChar[--n] = by2;
        this.fPartialMultiByteChar[--n] = by3;
    }

    private void savePartialMultiByte(int n, byte by, byte by2) {
        this.fPartialMultiByteIn = n--;
        this.fPartialMultiByteChar[n] = by;
        this.fPartialMultiByteChar[--n] = by2;
    }

    private void savePartialMultiByte(int n, byte by) {
        this.fPartialMultiByteIn = n--;
        this.fPartialMultiByteChar[n] = by;
    }

    private boolean handleMultiByteChar(byte by, byte[] byArray, int n, int n2, char[] cArray, int n3, int n4) throws Exception {
        byte by2;
        if (n == n2) {
            this.savePartialMultiByte(1, by);
            this.fPartialMultiByteResult = this.exitNormalize(n, n3, true);
            return false;
        }
        if (((by2 = byArray[n++]) & 0xC0) != 128) {
            Object[] objectArray = new Object[]{Integer.toHexString(by & 0xFF), Integer.toHexString(by2 & 0xFF)};
            this.deferException(2, objectArray, n3);
            cArray[n3++] = '\u0000';
            return this.exitNormalize(n, n3, true);
        }
        if ((by & 0xE0) == 192) {
            int n5 = ((0x1F & by) << 6) + (0x3F & by2);
            cArray[n3++] = (char)n5;
            if (n == n2 || n3 == n4) {
                this.fPartialMultiByteResult = this.exitNormalize(n, n3, n == n2);
                return false;
            }
        } else {
            byte by3;
            if (n == n2) {
                this.savePartialMultiByte(2, by2, by);
                this.fPartialMultiByteResult = this.exitNormalize(n, n3, true);
                return false;
            }
            if (((by3 = byArray[n++]) & 0xC0) != 128) {
                Object[] objectArray = new Object[]{Integer.toHexString(by & 0xFF), Integer.toHexString(by2 & 0xFF), Integer.toHexString(by3 & 0xFF)};
                this.deferException(3, objectArray, n3);
                cArray[n3++] = '\u0000';
                return this.exitNormalize(n, n3, true);
            }
            if ((by & 0xF0) == 224) {
                int n6 = ((0xF & by) << 12) + ((0x3F & by2) << 6) + (0x3F & by3);
                cArray[n3++] = (char)n6;
                if (n == n2 || n3 == n4) {
                    this.fPartialMultiByteResult = this.exitNormalize(n, n3, n == n2);
                    return false;
                }
            } else {
                byte by4;
                if ((by & 0xF8) != 240) {
                    Object[] objectArray = new Object[]{Integer.toHexString(by & 0xFF)};
                    this.deferException(1, objectArray, n3);
                    cArray[n3++] = '\u0000';
                    return this.exitNormalize(n, n3, true);
                }
                if (n == n2) {
                    this.savePartialMultiByte(3, by3, by2, by);
                    this.fPartialMultiByteResult = this.exitNormalize(n, n3, true);
                    return false;
                }
                if (((by4 = byArray[n++]) & 0xC0) != 128) {
                    Object[] objectArray = new Object[]{Integer.toHexString(by & 0xFF), Integer.toHexString(by2 & 0xFF), Integer.toHexString(by3 & 0xFF), Integer.toHexString(by4 & 0xFF)};
                    this.deferException(4, objectArray, n3);
                    cArray[n3++] = '\u0000';
                    return this.exitNormalize(n, n3, true);
                }
                int n7 = ((0xF & by) << 18) + ((0x3F & by2) << 12) + ((0x3F & by3) << 6) + (0x3F & by4);
                if (n7 >= 65536) {
                    cArray[n3++] = (char)((n7 - 65536 >> 10) + 55296);
                    n7 = (n7 - 65536 & 0x3FF) + 56320;
                    if (n3 == n4) {
                        this.fPartialSurrogatePair = n7;
                        this.fPartialMultiByteResult = this.exitNormalize(n, n3, n == n2);
                        return false;
                    }
                }
                cArray[n3++] = (char)n7;
                if (n == n2 || n3 == n4) {
                    this.fPartialMultiByteResult = this.exitNormalize(n, n3, n == n2);
                    return false;
                }
            }
        }
        return this.exitNormalize(n, n3, true);
    }

    private boolean handlePartialMultiByteChar(byte by, byte[] byArray, int n, int n2, char[] cArray, int n3, int n4) throws Exception {
        if (n3 == n4) {
            this.fPartialMultiByteResult = this.exitNormalize(n, n3, n == n2);
            return false;
        }
        if (this.fPartialMultiByteIn == 4) {
            cArray[n3++] = (char)this.fPartialSurrogatePair;
            if (n3 == n4) {
                this.fPartialMultiByteResult = this.exitNormalize(n, n3, false);
                return false;
            }
            this.fOutputOffset = n3;
            return true;
        }
        int n5 = this.fPartialMultiByteIn;
        this.fPartialMultiByteIn = 0;
        byte by2 = 0;
        byte by3 = 0;
        byte by4 = 0;
        switch (n5) {
            case 1: {
                by2 = by;
                break;
            }
            case 2: {
                by3 = by;
                break;
            }
            case 3: {
                by4 = by;
            }
        }
        int n6 = n5;
        switch (n5) {
            case 3: {
                by3 = this.fPartialMultiByteChar[--n6];
            }
            case 2: {
                by2 = this.fPartialMultiByteChar[--n6];
            }
            case 1: {
                by = this.fPartialMultiByteChar[--n6];
            }
        }
        switch (n5) {
            case 1: {
                if ((by2 & 0xC0) != 128) {
                    Object[] objectArray = new Object[]{Integer.toHexString(by), Integer.toHexString(by2)};
                    this.deferException(2, objectArray, n3);
                    cArray[n3++] = '\u0000';
                    break;
                }
            }
            case 2: {
                if ((by & 0xE0) == 192) {
                    int n7 = ((0x1F & by) << 6) + (0x3F & by2);
                    cArray[n3++] = (char)n7;
                    if (n3 == n4) {
                        this.fPartialMultiByteResult = this.exitNormalize(n, n3, false);
                        return false;
                    }
                    if (n5 >= 2 || ++n != n2) break;
                    this.fPartialMultiByteResult = this.exitNormalize(n, n3, true);
                    return false;
                }
                if (n5 < 2) {
                    if (++n == n2) {
                        this.savePartialMultiByte(2, by2);
                        this.fPartialMultiByteResult = this.exitNormalize(n, n3, true);
                        return false;
                    }
                    by3 = byArray[n];
                }
                if ((by3 & 0xC0) != 128) {
                    Object[] objectArray = new Object[]{Integer.toHexString(by), Integer.toHexString(by2), Integer.toHexString(by3)};
                    this.deferException(3, objectArray, n3);
                    cArray[n3++] = '\u0000';
                    break;
                }
            }
            case 3: {
                if ((by & 0xF0) == 224) {
                    int n8 = ((0xF & by) << 12) + ((0x3F & by2) << 6) + (0x3F & by3);
                    cArray[n3++] = (char)n8;
                    if (n3 == n4) {
                        this.fPartialMultiByteResult = this.exitNormalize(n, n3, false);
                        return false;
                    }
                    if (n5 >= 3 || ++n != n2) break;
                    this.fPartialMultiByteResult = this.exitNormalize(n, n3, true);
                    return false;
                }
                if (n5 < 3) {
                    if ((by & 0xF8) != 240) {
                        Object[] objectArray = new Object[]{Integer.toHexString(by)};
                        this.deferException(1, objectArray, n3);
                        cArray[n3++] = '\u0000';
                        break;
                    }
                    if (++n == n2) {
                        this.savePartialMultiByte(3, by3, by2);
                        this.fPartialMultiByteResult = this.exitNormalize(n, n3, true);
                        return false;
                    }
                    by4 = byArray[n];
                }
                if ((by4 & 0xC0) != 128) {
                    Object[] objectArray = new Object[]{Integer.toHexString(by), Integer.toHexString(by2), Integer.toHexString(by3), Integer.toHexString(by4)};
                    this.deferException(4, objectArray, n3);
                    cArray[n3++] = '\u0000';
                    break;
                }
                int n9 = ((0xF & by) << 18) + ((0x3F & by2) << 12) + ((0x3F & by3) << 6) + (0x3F & by4);
                if (n9 >= 65536) {
                    cArray[n3++] = (char)((n9 - 65536 >> 10) + 55296);
                    n9 = (n9 - 65536 & 0x3FF) + 56320;
                    if (n3 == n4) {
                        this.fPartialSurrogatePair = n9;
                        this.fPartialMultiByteResult = this.exitNormalize(n, n3, false);
                        return false;
                    }
                }
                cArray[n3++] = (char)n9;
                if (n3 == n4) {
                    this.fPartialMultiByteResult = this.exitNormalize(n, n3, false);
                    return false;
                }
                if (++n != n2) break;
                this.fPartialMultiByteResult = this.exitNormalize(n, n3, true);
                return false;
            }
        }
        return this.exitNormalize(n, n3, true);
    }
}

