/*
 * Decompiled with CFR 0.152.
 */
package eponine.model;

import cern.jet.stat.Gamma;
import eponine.model.BasisFunctionWithHistory;
import eponine.model.BundleConstraint;
import eponine.model.ConstraintBasisFunction;
import eponine.model.DiscreteDistribution;
import eponine.model.EnvelopedWaveDistribution;
import eponine.model.GaussianDistribution;
import eponine.model.ModelTools;
import eponine.model.PositionedConstraint;
import eponine.model.SquareWaveDistribution;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.symbol.FundamentalAtomicSymbol;
import stats.glm.BasisFunction;
import stats.glm.BasisSource;
import stats.glm.SLMTrainingContext;

public class DistributionBasisSource
extends FundamentalAtomicSymbol
implements BasisSource {
    private double distChangeWidth;
    private double distChangeGamma = 10.0;
    private double distChangeScale = 1.0;
    private double distChangeBias = 0.0;
    private String name = "distwidth";
    private double shapeChangeProbability = 0.0;
    private double flipEnvelopeProbability = 0.0;
    private static final int NUM_SAMPLES = 10;

    public DistributionBasisSource() {
        super("distwidth", ' ', Annotation.EMPTY_ANNOTATION);
    }

    public void setDistChangeWidth(double d) {
        this.distChangeWidth = d;
    }

    public void setDistChangeBias(double d) {
        this.distChangeBias = d;
    }

    public void setDistChangeGamma(double d) {
        this.distChangeGamma = d;
    }

    public void setDistChangeScale(double d) {
        this.distChangeScale = d;
    }

    public void setShapeChangeProbability(double d) {
        this.shapeChangeProbability = d;
    }

    public void setFlipEnvelopeProbability(double d) {
        this.flipEnvelopeProbability = d;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public BasisFunction next(SLMTrainingContext sLMTrainingContext) {
        Object object;
        Object object2;
        Object object3;
        List list = sLMTrainingContext.getBasisList();
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object3 = (BasisFunction)iterator.next();
            object2 = ModelTools.removeHistory((BasisFunction)object3);
            if (!(object2 instanceof ConstraintBasisFunction)) continue;
            object = (PositionedConstraint)((ConstraintBasisFunction)object2).getConstraint();
            int n2 = 1;
            if (((PositionedConstraint)object).getConstraint() instanceof BundleConstraint) {
                n2 += ((BundleConstraint)((PositionedConstraint)object).getConstraint()).getConstraints().size();
            }
            if (hashMap.containsKey(object)) {
                System.out.println("Duplicate!  How did that get there?");
            }
            hashMap.put(object3, new Integer(n2));
            n += n2;
        }
        n = (int)Math.ceil((double)n * Math.random());
        object3 = hashMap.entrySet().iterator();
        while (object3.hasNext()) {
            object2 = (Map.Entry)object3.next();
            if ((n -= ((Integer)object2.getValue()).intValue()) == 0) {
                object = (BasisFunction)object2.getKey();
                PositionedConstraint positionedConstraint = (PositionedConstraint)ModelTools.getConstraint((BasisFunction)object);
                return new BasisFunctionWithHistory(new ConstraintBasisFunction(this.samplePositionedConstraint(positionedConstraint)), Collections.singleton(object), this, sLMTrainingContext.getCurrentCycle());
            }
            if (n >= 0) continue;
            object = (BasisFunction)object2.getKey();
            PositionedConstraint positionedConstraint = (PositionedConstraint)ModelTools.getConstraint((BasisFunction)object);
            ArrayList<PositionedConstraint> arrayList = new ArrayList<PositionedConstraint>(((BundleConstraint)positionedConstraint.getConstraint()).getConstraints());
            PositionedConstraint positionedConstraint2 = (PositionedConstraint)arrayList.get(-(n + 1));
            arrayList.set(-(n + 1), this.samplePositionedConstraint(positionedConstraint2));
            return new BasisFunctionWithHistory(new ConstraintBasisFunction(new PositionedConstraint(new BundleConstraint(arrayList), positionedConstraint.getPosition(), positionedConstraint.getDistribution(), positionedConstraint.isMaximum())), Collections.singleton(object), this, sLMTrainingContext.getCurrentCycle());
        }
        throw new BioError("totalProb exceeded");
    }

    private PositionedConstraint samplePositionedConstraint(PositionedConstraint positionedConstraint) {
        PositionedConstraint positionedConstraint2 = new PositionedConstraint(positionedConstraint.getConstraint(), positionedConstraint.getPosition(), this.sampleDistribution(positionedConstraint.getDistribution()), positionedConstraint.isMaximum());
        return positionedConstraint2;
    }

    private DiscreteDistribution sampleDistribution(DiscreteDistribution discreteDistribution) {
        return this.sampleDistribution(discreteDistribution, true);
    }

    private DiscreteDistribution sampleDistribution(DiscreteDistribution discreteDistribution, boolean bl) {
        if (discreteDistribution instanceof EnvelopedWaveDistribution) {
            return this.sampleEnveloped((EnvelopedWaveDistribution)discreteDistribution);
        }
        if (bl && Math.random() < this.flipEnvelopeProbability) {
            return new EnvelopedWaveDistribution(discreteDistribution, Math.random() * 10.2);
        }
        if (discreteDistribution instanceof GaussianDistribution) {
            return this.sampleGaussian((GaussianDistribution)discreteDistribution);
        }
        return this.sampleSquareWave((SquareWaveDistribution)discreteDistribution);
    }

    private DiscreteDistribution sampleGaussian_old(GaussianDistribution gaussianDistribution) {
        double d = gaussianDistribution.getWidth();
        if (Math.random() < this.shapeChangeProbability) {
            return new SquareWaveDistribution((int)Math.ceil(d));
        }
        double d2 = Math.abs(d * (1.0 + this.distChangeBias + ModelTools.gauss() * this.distChangeWidth));
        return new GaussianDistribution(d2);
    }

    private DiscreteDistribution sampleGaussian(GaussianDistribution gaussianDistribution) {
        double d = gaussianDistribution.getWidth();
        double[] dArray = new double[10];
        double[] dArray2 = new double[10];
        double d2 = 0.0;
        int n = 0;
        while (n < 10) {
            dArray[n] = Math.abs(d + ModelTools.gauss() * this.distChangeWidth);
            dArray2[n] = this.gammaPDFStar(this.distChangeGamma, dArray[n] / this.distChangeScale);
            d2 += dArray2[n];
            ++n;
        }
        d2 *= Math.random();
        int n2 = 0;
        while (n2 < 10) {
            if ((d2 -= dArray2[n2]) <= 0.0) {
                return new GaussianDistribution(dArray[n2]);
            }
            ++n2;
        }
        throw new BioError("TotalProb exceeded");
    }

    private double gammaPDFStar(double d, double d2) {
        return Math.pow(d2, d - 1.0) * Math.exp(-d2);
    }

    private double standardGammaPDF(double d, double d2) {
        return Math.pow(d2, d - 1.0) * Math.exp(-d2) / Gamma.gamma(d);
    }

    private DiscreteDistribution sampleSquareWave(SquareWaveDistribution squareWaveDistribution) {
        int n = squareWaveDistribution.getWidth();
        if (Math.random() < this.shapeChangeProbability) {
            return new GaussianDistribution(n);
        }
        int n2 = (int)Math.round(Math.abs((double)n * (1.0 + this.distChangeBias + ModelTools.gauss() * this.distChangeWidth)));
        return new SquareWaveDistribution(n2);
    }

    private DiscreteDistribution sampleEnveloped(EnvelopedWaveDistribution envelopedWaveDistribution) {
        if (Math.random() < this.flipEnvelopeProbability) {
            return envelopedWaveDistribution.getEnvelope();
        }
        if (Math.random() < 0.5) {
            return new EnvelopedWaveDistribution(envelopedWaveDistribution.getEnvelope(), envelopedWaveDistribution.getPhase() + ModelTools.gauss());
        }
        return new EnvelopedWaveDistribution(this.sampleDistribution(envelopedWaveDistribution.getEnvelope(), false), envelopedWaveDistribution.getPhase());
    }

    public boolean hasNext(SLMTrainingContext sLMTrainingContext) {
        return sLMTrainingContext.getCurrentCycle() > 0 && sLMTrainingContext.getBasisList().size() >= 3;
    }
}

