% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{plot_credible_intervals}
\alias{plot_credible_intervals}
\title{plot_credible interval for theoretical data distributions}
\usage{
plot_credible_intervals(.data)
}
\arguments{
\item{.data}{The tibble returned by identify_outliers}
}
\value{
A tibble with an additional \code{plot} column
}
\description{
Plot the data along the theoretical data distribution.
}
\examples{

library(dplyr)

data("counts")

if(Sys.info()[['sysname']] == "Linux"){
result =
  counts \%>\%
  dplyr::mutate(  is_significant = ifelse(symbol \%in\% c("SLC16A12", "CYP1A1", "ART3"), TRUE, FALSE) ) \%>\%
 ppcseq::identify_outliers(
	formula = ~ Label,
	sample, symbol, value,
	.significance = PValue,
	.do_check  = is_significant,
	percent_false_positive_genes = 1,
	tol_rel_obj = 0.01,
	approximate_posterior_inference =TRUE,
	approximate_posterior_analysis =TRUE,
	how_many_negative_controls = 50,
	cores=1
)

result_plot = result \%>\% plot_credible_intervals()
}

}
