% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cutoff_select.R
\name{bc_to_freq_cutoff}
\alias{bc_to_freq_cutoff}
\alias{freq_to_bc_cutoff}
\title{Convert between cutoff types}
\usage{
bc_to_freq_cutoff(freq_table, cutoff)

freq_to_bc_cutoff(freq_table, cutoff)
}
\arguments{
\item{freq_table}{The frequency table
from \code{\link[=create_freq_table]{create_freq_table()}}. In case the table is derived
from another source, it must be sorted in descending
order of frequency.}

\item{cutoff}{Integer vector, the cutoff values to be converted.}
}
\value{
Integer, the converted cutoff values.
}
\description{
There are at least two ways to specify the cutoff to use when
selecting barcode combinations (cells) for further analysis. One way is
to specify the number of barcode combinations to keep, effectively
keeping a given number of barcode combinations with the highest frequencies.
The other way is to specify the frequency cutoff directly
without regard to the number
of barcode combination to keep. In the former case,
\code{bc_to_freq_cutoff()} is used to find
the corresponding frequency cutoff,
whereas in the latter case \code{freq_to_bc_cutoff()}
is used to find the corresponding barcode cutoff.
}
\details{
In the edge case of the barcode threshold being zero, the frequency cutoff
is set to the maximum frequency in the table plus one. This feature
makes sure that the cutoff line is visible in the frequency plot.
}
\examples{
library(purrr)
library(Biostrings)
input_fastq <- system.file(
    "extdata", "PETRI-seq_forward_reads.fq.gz",
    package = "posDemux")
reads <- readDNAStringSet(input_fastq, format = "fastq")
barcode_files <- system.file(
    "extdata/PETRI-seq_barcodes", c(bc1 = "bc1.fa", bc2 = "bc2.fa",
    bc3 = "bc3.fa"), package = "posDemux")
names(barcode_files) <- paste0("bc", 1L:3L)
barcode_index <- map(barcode_files, readDNAStringSet)
barcodes <- barcode_index[c("bc3", "bc2", "bc1")]
sequence_annotation <- c(UMI = "P", "B", "A", "B", "A", "B", "A")
segment_lengths <- c(7L, 7L, 15L, 7L, 14L, 7L, NA_integer_)
demultiplex_res <- posDemux::combinatorial_demultiplex(
    reads, barcodes = barcodes, segments = sequence_annotation,
    segment_lengths = segment_lengths)
filtered_res <- filter_demultiplex_res(demultiplex_res, allowed_mismatches = 1L)
freq_table <- create_freq_table(filtered_res$demultiplex_res$assigned_barcodes)

bc_cutoff <- c(100L, 204L, 50L, 655L)
freq_cutoff <- bc_to_freq_cutoff(freq_table, bc_cutoff)
# Note: The reconstructed barcode cutoff is not equal to
# the original due to ties in the frequency table
reconstructed_bc_cutoff <- freq_to_bc_cutoff(freq_table, freq_cutoff)
# The frequency cutoff is still preserved through these conversions
reconstruced_freq_cutoff <- bc_to_freq_cutoff(
    freq_table, reconstructed_bc_cutoff)
}
