% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr-select.R
\name{select}
\alias{select}
\alias{select.PlySummarizedExperiment}
\title{select assays, rowData, and colData names}
\usage{
\method{select}{PlySummarizedExperiment}(.data, ...)
}
\arguments{
\item{.data}{An object Inheriting from \code{PlySummarizedExperiment}, the wrapper
class for \code{SummarizedExperiment} objects}

\item{...}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> one or more selection
expressions. Supports wrapping expressions within the
<\code{\link[=plyxp-context]{plyxp-contexts}}>.}
}
\value{
an object inheriting PlySummarizedExperiment class
}
\description{
Select one or more values from each context. By default omitting an expression
for a context is the same as selecting NOTHING from that context.

The <\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> implementation within
\code{plyxp} is almost similar to \code{dplyr} except when used within the
\code{across()} function. When used from \code{accross()}, the data provided to
\link[tidyselect:eval_select]{eval_select} is a zero length slice of the data.
This was an intentional choice to prevent the evaluation of potentionally
expensive chopping operations for S4Vectors. This means that predicate
function from \code{\link[tidyselect:where]{where()}} will NOT be able to query the
original data.
}
\examples{


# only keep assays, other contexts are dropped
select(se_simple, everything())

# only keep rowData, other contexts are dropped
select(se_simple, rows(everything()))

select(se_simple, rows(where(is.numeric)))

# Note on `where()` clause, all data is available within select
select(se_simple, rows(where(~ any(grepl("-", .x)))))

# within an `across()`, only a zero-length slice avialble, so the
# `where()` predicate cannot access the data
mutate(
  se_simple,
  rows(
    across(
      where(~ any(grepl("-", .x))),
      ~ sprintf("\%s foo", .x)
    )
  )
)
# here is an acceptable usage of the `where()` predicate
mutate(
  se_simple,
  rows(
    across(
      where(is.character),
      ~ sprintf("\%s foo", .x)
    )
  )
)

}
