% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranges-reduce.R
\name{reduce_ranges}
\alias{reduce_ranges}
\alias{reduce_ranges_directed}
\title{Reduce then aggregate a Ranges object}
\usage{
reduce_ranges(.data, min.gapwidth = 1L, ...)

reduce_ranges_directed(.data, min.gapwidth = 1L, ...)
}
\arguments{
\item{.data}{a Ranges object to reduce}

\item{min.gapwidth}{Ranges separated by a gap of at least min.gapwidth positions are not merged.}

\item{...}{Name-value pairs of summary functions.}
}
\value{
a Ranges object with the
}
\description{
Reduce then aggregate a Ranges object
}
\examples{
set.seed(10)
df <- data.frame(start = sample(1:10), 
                 width = 5,  
                 seqnames = "seq1",
                 strand = sample(c("+", "-", "*"), 10, replace = TRUE), 
                 gc = runif(10))
                 
rng <- as_granges(df)
rng \%>\% reduce_ranges()
rng \%>\% reduce_ranges(gc = mean(gc))
rng \%>\% reduce_ranges_directed(gc = mean(gc))
rng \%>\% reduce_ranges_directed(gc = mean(gc), min.gapwidth = 10)

x <- data.frame(start = c(11:13, 2, 7:6), 
               width=3, 
               id=sample(letters[1:3], 6, replace = TRUE),
               score= sample(1:6))
x <- as_iranges(x)
x \%>\% reduce_ranges()
x \%>\% reduce_ranges(score = sum(score))
x \%>\% group_by(id) \%>\% reduce_ranges(score = sum(score))
}
