% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranges-disjoin.R
\name{disjoin_ranges}
\alias{disjoin_ranges}
\alias{disjoin_ranges_directed}
\title{Disjoin then aggregate a Ranges object}
\usage{
disjoin_ranges(.data, ...)

disjoin_ranges_directed(.data, ...)
}
\arguments{
\item{.data}{a Ranges object to disjoin}

\item{...}{Name-value pairs of summary functions.}
}
\value{
a Ranges object that is now disjoint (no bases overlap).
}
\description{
Disjoin then aggregate a Ranges object
}
\examples{
df <- data.frame(start = 1:10, width = 5,  seqnames = "seq1",
strand = sample(c("+", "-", "*"), 10, replace = TRUE), gc = runif(10))
rng <- as_granges(df)
rng \%>\% disjoin_ranges()
rng \%>\% disjoin_ranges(gc = mean(gc))
rng \%>\% disjoin_ranges_directed(gc = mean(gc))
}
