% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io-bed.R
\name{write_bed}
\alias{write_bed}
\alias{write_bed_graph}
\alias{write_narrowpeaks}
\title{Write a BED or BEDGraph file}
\usage{
write_bed(x, file, index = FALSE)

write_bed_graph(x, file, index = FALSE)

write_narrowpeaks(x, file)
}
\arguments{
\item{x}{A GRanges object}

\item{file}{File name, URL or connection specifying a file to write x to.
Compressed files with extensions such as '.gz' are handled
automatically. If you want to index the file with tabix use the
\code{index} argument.}

\item{index}{Compress and index the output file
with bgzf and tabix (default = FALSE). Note that tabix indexing will sort the
data by chromosome and start.}
}
\value{
The write functions return a BED(Graph)File invisibly
}
\description{
This is a lightweight wrapper to the export family
of functions defined in \pkg{rtracklayer}.
}
\examples{
\dontrun{
  test_path <- system.file("tests", package = "rtracklayer")
  bed_file <- file.path(test_path, "test.bed")
  gr <- read_bed(bed_file)
  bed_file_out <- file.path(tempdir(), "new.bed")
  write_bed(gr, bed_file_out)
  read_bed(bed_file_out)
  #' bedgraph
  bg_file <- file.path(test_path, "test.bedGraph")
  gr <- read_bed_graph(bg_file)
  bg_file_out <- file.path(tempdir(), "new.bg")
  write_bed(gr, bg_file_out)
  read_bed(bg_file_out)
  # narrowpeaks
  np_file <- system.file("extdata", "demo.narrowPeak.gz",package="rtracklayer")
  gr <- read_narrowpeaks(np_file, genome_info = "hg19")
  np_file_out <- file.path(tempdir(), "new.bg")
  write_narrowpeaks(gr, np_file_out)
  read_narrowpeaks(np_file_out)
}
}
\seealso{
\code{rtracklayer::\link[rtracklayer:BEDFile-class]{BEDFile()}}
}
