% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutate.R
\name{dplyr-mutate}
\alias{dplyr-mutate}
\alias{mutate.GInteractions}
\title{Mutate columns from a GInteractions object}
\usage{
\method{mutate}{GInteractions}(.data, ...)
}
\arguments{
\item{.data}{a GInteractions object}

\item{...}{Optional named arguments specifying which the columns in .data
to create/modify.}
}
\value{
a GInteractions object.
}
\description{
Mutate columns from a GInteractions object
}
\examples{
gi <- read.table(text = "
chr1 10 20 chr1 50 51
chr1 10 50 chr2 30 40",
col.names = c("chr1", "start1", "end1", "chr2", "start2", "end2")) |> 
  as_ginteractions(seqnames1 = chr1, seqnames2 = chr2)
  
####################################################################
# 1. Add metadata columns to a GInteractions object
####################################################################

gi |> 
  mutate(type = c('cis', 'trans'), score = runif(2)) |> 
  mutate(type2 = type)

####################################################################
# 2. More complex, nested or inplace changes
####################################################################

gi |> 
  mutate(type = c('cis', 'trans'), score = runif(2)) |> 
  mutate(type2 = type) |> 
  mutate(count = c(1, 2), score = count * 2, new_col = paste0(type2, score))

####################################################################
# 3. Core GInteractions columns can also be modified
####################################################################

gi |> 
  mutate(start1 = 1, end1 = 10, width2 = 30, strand2 = c('-', '+'))

# Note how the core columns are modified sequentially 

gi |> 
  mutate(start1 = 1, end1 = 10)

gi |> 
  mutate(start1 = 1, end1 = 10, width1 = 50)

####################################################################
# 4. Evaluating core GInteractions columns
####################################################################

gi |> 
  mutate(
    score = runif(2), 
    cis = seqnames1 == seqnames2, 
    distance = ifelse(cis, start2 - end1, NA)
  )
}
