% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotRect.R
\name{plotRect}
\alias{plotRect}
\title{Plot a rectangle within a plotgardener layout}
\usage{
plotRect(
    x,
    y,
    width,
    height,
    just = "center",
    default.units = "inches",
    linecolor = "black",
    lwd = 1,
    lty = 1,
    fill = NA,
    alpha = 1,
    params = NULL,
    ...
)
}
\arguments{
\item{x}{A numeric vector or unit object specifying rectangle x-locations.}

\item{y}{A numeric vector, unit object, or a character vector of values
containing a "b" combined with a numeric value specifying
rectangle y-locations.
The character vector will place rectangle y-locations relative to
the bottom of the most recently plotted plot according to
the units of the plotgardener page.}

\item{width}{A numeric vector or unit object specifying rectangle widths.}

\item{height}{A numeric vector or unit object specifying rectangle heights.}

\item{just}{Justification of rectangle relative to its (x, y) location.
If there are two values, the first value specifies horizontal justification
and the second value specifies vertical justification.
Possible string values are: \code{"left"}, \code{"right"},
\code{"centre"}, \code{"center"}, \code{"bottom"}, and \code{"top"}.
Default value is \code{just = "center"}.}

\item{default.units}{A string indicating the default units to use if
\code{x}, \code{y}, \code{width}, and \code{height} are only given as
numerics or numeric vectors.
Default value is \code{default.units = "inches"}.}

\item{linecolor}{A character value specifying rectangle line color.
Default value is \code{linecolor = "black"}.}

\item{lwd}{A numeric specifying rectangle line width.
Default value is \code{lwd = 1}.}

\item{lty}{A numeric specifying rectangle line type.
Default value is \code{lty = 1}.}

\item{fill}{A character value specifying rectangle fill color.
Default value is \code{fill = NA}.}

\item{alpha}{Numeric value specifying color transparency.
Default value is \code{alpha = 1}.}

\item{params}{An optional \link[plotgardener]{pgParams} object
containing relevant function parameters.}

\item{...}{Additional grid graphical parameters. See \link[grid]{gpar}.}
}
\value{
Returns a \code{rect} object containing
relevant placement and \link[grid]{grob} information.
}
\description{
Plot a rectangle within a plotgardener layout
}
\examples{
## Create a page
pageCreate(width = 7.5, height = 6, default.units = "inches")

## Plot one rectangle with no fill
plotRect(
    x = 0.5, y = 0.5, width = 3, height = 3,
    just = c("left", "top"), default.units = "inches",
    lwd = 2, fill = NA
)


## Plot two rectangles with same width and height at different locations
plotRect(
    x = 4, y = c(0.5, 2.25), width = 3, height = 1.25,
    just = c("left", "top"), default.units = "inches",
    fill = "#7ecdbb"
)

## Plot two rectangles with different widths, heights,
## locations, and colors
plotRect(
    x = 3.75, y = c(4, 5.25), width = c(6.5, 4.5),
    height = c(1, 0.25),
    just = "top", default.units = "inches",
    fill = c("#7ecdbb", "#37a7db"), linecolor = NA, alpha = 0.4
)

## Hide page guides
pageGuideHide()
}
\seealso{
\link[grid]{grid.rect}
}
