% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotGG.R
\name{plotGG}
\alias{plotGG}
\title{Plot a ggplot2 plot, gtable, or grob object in a plotgardener layout}
\usage{
plotGG(
    plot,
    x,
    y,
    width,
    height,
    just = c("left", "top"),
    default.units = "inches",
    params = NULL
)
}
\arguments{
\item{plot}{ggplot, gtable, or grob object.}

\item{x}{A numeric or unit object specifying ggplot x-location.}

\item{y}{A numeric, unit object, or character containing a "b"
combined with a numeric value specifying ggplot y-location.
The character value will
place the ggplot y relative to the bottom of the most recently
plotted plot according to the units of the plotgardener page.}

\item{width}{A numeric or unit object specifying ggplot width.}

\item{height}{A numeric or unit object specifying ggplot height.}

\item{just}{Justification of ggplot relative to its (x, y) location.
If there are two values, the first value specifies horizontal
justification and the second value specifies vertical justification.
Possible string values are: \code{"left"}, \code{"right"},
\code{"centre"}, \code{"center"}, \code{"bottom"}, and \code{"top"}.
Default value is \code{just = c("left", "top")}.}

\item{default.units}{A string indicating the default units to use
if \code{x}, \code{y}, \code{width}, or \code{height} are only given
as numerics. Default value is \code{default.units = "inches"}.}

\item{params}{An optional \link[plotgardener]{pgParams} object containing
relevant function parameters.}
}
\value{
Returns a \code{pg_gg} object containing
relevant placement and \link[grid]{grob} information.
}
\description{
Plot a ggplot2 plot, gtable, or grob object in a plotgardener layout
}
\examples{
## Create a plot using ggplot2
library(ggplot2)
p <- ggplot(mtcars) +
    geom_point(aes(mpg, disp))

## Create a page
pageCreate(width = 4, height = 4, default.units = "inches")

## Place ggplot in page
plotGG(
    plot = p, x = 0.5, y = 0.5, width = 3, height = 3,
    just = c("left", "top"), default.units = "inches"
)

## Add title
plotText(
    label = "mtcars", fontsize = 14, fontface = "bold",
    x = 1, y = 0.35
)

## Hide page guides
pageGuideHide()
}
\seealso{
\link[ggplot2]{ggplot}
}
