% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pageLayout.R
\name{pageLayoutRow}
\alias{pageLayoutRow}
\title{Generate row positions for a number of plot elements with a specified height
and space between them}
\usage{
pageLayoutRow(y, height, space, n, default.units = "inches")
}
\arguments{
\item{y}{A numeric or unit object specifying the starting row y-position.}

\item{height}{A numeric or unit object specifying the height of rows.}

\item{space}{A numeric or unit object specifying the space between rows.}

\item{n}{An integer specifying the number of elements to generate row 
positions for.}

\item{default.units}{A string indicating the default units to use
if \code{y}, \code{h}, or \code{s} are only given as numerics.
Default value is \code{default.units = "inches"}.}
}
\value{
Returns a unit vector of page positions.
}
\description{
Generate row positions for a number of plot elements with a specified height
and space between them
}
\examples{
# Starting at 0.5 units, return a vector of positions for 3 objects that
# are 2 units in height with 0.1 units of space between them

pageLayoutRow(y = 0.5, height = 2, space = 0.1, n = 3, 
            default.units = "inches")

}
