% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictAge.R
\name{predictAge}
\alias{predictAge}
\title{Predicts gestational age using placental DNA methylation microarray
data}
\usage{
predictAge(betas, type = "RPC")
}
\arguments{
\item{betas}{An n by m dataframe of methylation values on the beta scale (0,
1), where the CpGs are arranged in rows, and samples in columns. Should
contain all CpGs used in each clock}

\item{type}{One of the following: "RPC" (Robust), "CPC", (Control) or "RRPC"
(Refined Robust).}
}
\value{
A vector of length \code{m}, containing inferred gestational age.
}
\description{
\code{predictAge} Multiplies the coefficients from one of three
epigenetic gestational age clocks, by the corresponding CpGs in a supplied
betas \code{data.frame}.
}
\details{
Predicts gestational age using one of 3 placental gestational age
clocks: RPC, CPC, or refined RPC. Requires placental DNA methylation measured
on the Infinium 27K/450k/EPIC methylation array. Ensure as many predictive
CpGs are present in your data, otherwise accuracy may be impacted.

It's recommended that you have all predictive CpGs, otherwise accuracy may
vary.
}
\examples{

# Load placenta DNAm data
library(dplyr)
data(plBetas)
data(plPhenoData)

plPhenoData \%>\%
    mutate(inferred_ga = predictAge(plBetas, type = "RPC"))
    
}
