% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plaid.R
\name{replaid.ucell}
\alias{replaid.ucell}
\title{Fast calculation of UCell}
\usage{
replaid.ucell(
  X,
  matG,
  rmax = 1500,
  assay = "logcounts",
  min.genes = 5,
  max.genes = 500
)
}
\arguments{
\item{X}{Gene or protein expression matrix. Generally log
transformed. See details. Genes on rows, samples on columns.
Also accepts SummarizedExperiment or SingleCellExperiment objects.}

\item{matG}{Gene sets sparse matrix. Genes on rows, gene sets on columns.
Also accepts BiocSet objects or GMT lists.}

\item{rmax}{Rank threshold (see Ucell paper). Default rmax = 1500.}

\item{assay}{Character: assay name for Bioconductor objects. Default "logcounts".}

\item{min.genes}{Integer: minimum genes per gene set. Default 5.}

\item{max.genes}{Integer: maximum genes per gene set. Default 500.}
}
\value{
Matrix of single-sample UCell enrichment scores.
Gene sets on rows, samples on columns.
}
\description{
Calculates single-sample enrichment UCell (Andreatta
et al., 2021) using plaid back-end. The computation is
10-100x faster than the original code.
}
\details{
Computing ssGSEA score requires to compute the ranks of
the expression matrix and truncation of the ranks. We have wrapped
this in a single convenience function.

We have extensively compared the results of \code{replaid.ucell} and
from the original \code{UCell} R package and we showed near exacct
results in the score, logFC and p-values.
}
\examples{
# Create example expression matrix
set.seed(123)
X <- matrix(rnorm(500), nrow = 50, ncol = 10)
rownames(X) <- paste0("GENE", 1:50)
colnames(X) <- paste0("Sample", 1:10)

# Create example gene sets
gmt <- list(
  "Pathway1" = paste0("GENE", 1:15),
  "Pathway2" = paste0("GENE", 10:25)
)
matG <- gmt2mat(gmt)

# Compute UCell scores (default rmax = 1500)
scores <- replaid.ucell(X, matG)
print(scores[1:2, 1:5])

# Compute UCell scores with custom rmax
scores_custom <- replaid.ucell(X, matG, rmax = 1000)
print(scores_custom[1:2, 1:5])

}
