% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pgca.R
\name{pgcaDict}
\alias{pgcaDict}
\title{Link Protein Groups Created from MS/MS Data}
\usage{
pgcaDict(..., col.mapping, master.gene.identifier)
}
\arguments{
\item{...}{arbitrary number of directory names, file names, or
\code{data.frame}s used as input.}

\item{col.mapping}{column mapping (see Details).}

\item{master.gene.identifier}{if given, genes with this value in the
column \code{group.identifier} are considered master genes.}
}
\value{
An object of type \code{pgcaDict}.
}
\description{
Build a dictionary for protein groups from MS/MS data.
Details of the algorithm can be found in Takhar et al. (Under revision).
"PGCA: An Algorithm to Link Protein Groups Created from MS/MS Data.".
}
\details{
If the \code{group.identifier} column is logical (i.e., \code{TRUE} or
\code{FALSE}) or \code{master.gene.identifier} is given,
the \code{TRUE} accessions are assumed to be a "master gene" and the
data set is assumed to be in the correct order. This means all
\code{FALSE} values following the master gene are assumed to belong to
the same group.

The \code{col.mapping} maps the column names in the data files to a specific
function. It nees to be a named character vector, whereas the name of each
item is the "function" of the given column name. The algorithm knows about
the following columns:
\describe{
     \item{\code{"group.identifier"}}{Column containing the group
                                      identifier.}
     \item{\code{"accession.nr"}}{Column containing the accession nr.}
     \item{\code{"protein.name"}}{Column containing the protein name.}
     \item{\code{"gene.symbol"}}{Column containing the gene symbol (if any,
                                 can be missing)}
}
The default column mapping is \code{c(group.identifier="N", accession.nr =
"Accession", protein.name="Protein_Name")}. The supplied column mapping can
ignore those columns that are already correct in the default map.
For instance, if the accession nr. is stored in column \emph{AccessionNr}
instead of \emph{Accession}, but the remaining columns are the same as in the
default mapping, specifying \code{col.mapping=c(accession.nr="AccessionNr")}
is sufficient.
}
\examples{
# Build the dictionary from all files in a directory
# and specifying the column "Gene_Symbol" holds the `gene.symbol`.
dict.dir <- pgcaDict(
         system.file("extdata", package="pgca"),
         col.mapping=c(gene.symbol="Gene_Symbol")
)

# Build the dictionary from a list of files
dict.files <- pgcaDict(
     system.file("extdata", "BET1947_v339.txt", package="pgca"),
     system.file("extdata", "BET2007_v339.txt", package="pgca"),
     system.file("extdata", "BET2047_v339.txt", package="pgca"),
     col.mapping=c(gene.symbol="Gene_Symbol")
)

# Build the dictionary from already read-in data.frames
dict.data <- pgcaDict(BET1947_v339, BET2047_v339,
                      col.mapping=c(gene.symbol="Gene_Symbol"))

}
\references{
Takhar M, Sasaki M, Hollander Z, McManus B, McMaster W, Ng R and
   Cohen Freue G (Under revision). "PGCA: An Algorithm to Link Protein Groups
   Created from MS/MS Data." PLOS ONE.
}
\seealso{
\code{\link{applyDict}} to apply the dictionary to the data files
     and \code{\link{saveDict}} to save the dictionary itself.
}
