% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_peakPantheRAnnotation.R
\docType{methods}
\name{outputAnnotationResult,peakPantheRAnnotation-method}
\alias{outputAnnotationResult,peakPantheRAnnotation-method}
\alias{outputAnnotationResult}
\title{Save to disk all annotation results as csv files}
\usage{
\S4method{outputAnnotationResult}{peakPantheRAnnotation}(
    object,
    saveFolder,
    annotationName = "annotationResult",
    verbose = TRUE
)
}
\arguments{
\item{object}{(peakPantheRAnnotation) Annotated peakPantheRAnnotation object}

\item{saveFolder}{(str) Path of folder where the annotation result csv will
be saved}

\item{annotationName}{(str) name of annotation to use in the saved csv}

\item{verbose}{(bool) If TRUE message progress}
}
\value{
None
}
\description{
Save to disk all annotation results as
\code{annotationName_ ... .csv} files: compound metadata (\code{cpdMetadata},
\code{cpdID}, \code{cpdName}) and spectra metadata (\code{spectraMetadata},
\code{acquisitionTime}, \code{TIC}), summary of fit (ratio of peaks found:
\code{ratio_peaks_found}, ratio of peaks filled: \code{ratio_peaks_filled},
mean ppm_error: \code{ppm_error}, mean rt_dev_sec: \code{rt_dev_sec}), and a
file for each column of \code{peakTables} (with samples as rows and compounds
as columns)
}
\examples{
if(requireNamespace('faahKO')){
## Initialise a peakPantheRAnnotation object with 3 samples and 2 targeted
## compounds

# Paths to spectra files
library(faahKO)
spectraPaths <- c(system.file('cdf/KO/ko15.CDF', package = 'faahKO'),
                    system.file('cdf/KO/ko16.CDF', package = 'faahKO'),
                    system.file('cdf/KO/ko18.CDF', package = 'faahKO'))

# targetFeatTable
targetFeatTable <- data.frame(matrix(vector(), 2, 8, dimnames=list(c(),
                    c('cpdID','cpdName','rtMin','rt','rtMax','mzMin','mz',
                    'mzMax'))), stringsAsFactors=FALSE)
targetFeatTable[1,] <- c('ID-1', 'Cpd 1', 3310., 3344.888, 3390., 522.194778,
                        522.2, 522.205222)
targetFeatTable[2,] <- c('ID-2', 'Cpd 2', 3280., 3385.577, 3440., 496.195038,
                        496.2, 496.204962)
targetFeatTable[,c(3:8)] <- vapply(targetFeatTable[,c(3:8)], as.numeric,
                                    FUN.VALUE=numeric(2))

emptyAnnotation <- peakPantheRAnnotation(spectraPaths=spectraPaths,
                                        targetFeatTable=targetFeatTable)

# Calculate annotation
annotation      <- peakPantheR_parallelAnnotation(emptyAnnotation, ncores=0,
                                getAcquTime=FALSE, verbose=FALSE)$annotation

# temporary location
savePath1       <- tempdir()
outputAnnotationResult(annotation, saveFolder=savePath1,
                        annotationName='testProject', verbose=TRUE)
}
}
