% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centerExpandRegionsHelper.R
\name{defineExpansion}
\alias{defineExpansion}
\title{Calculate expansion value from median input region size}
\usage{
defineExpansion(data = data, expandBy = expandBy)
}
\arguments{
\item{data}{PeakCombiner data frame structure with required columns
named \code{chrom}, \code{start}, \code{end}, \code{name},
\code{score}, \code{strand}, \code{center}, \code{sample_name}. Additional
columns will be maintained.}

\item{expandBy}{Allowed values a numeric vector of length 1 or 2,
or 'NULL' (default).
\itemize{
\item The value from the numeric vector of length 1
is expanded in both directions from center to define
the genomic region.
Thus, the size of the resulting genomic region is 2x
the provided value + 1 (for the center coordinate).
\item The value of the numeric vector of length 2
subtracts the first value from the center and adds
the second value to the center to define the genomic
region. Thus, the size of the genomic regions is
the sum of the first value + the second value
+ 1 (for the center coordinate).
\item 'NULL' allows for data-driven definition of the
\code{expandBy} value. It calculates the median
genomic region size of the input data and uses this
value like a length 1 numeric vector for expansion.
}}
}
\value{
A vector of length 1 to define region expansion.
}
\description{
Calculates the parameter \code{expandBy} when it was set to 'NULL' in the main
function. 'NULL' allows for data-driven definition of the \code{expandBy} value.
It calculates the median genomic region size of the input data and uses this
value like a length 1 numeric vector for expansion.
}
