% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcaplot.R
\name{pcascree}
\alias{pcascree}
\title{Scree plot of the PCA on the samples}
\usage{
pcascree(obj, type = c("pev", "cev"), pc_nr = NULL, title = NULL)
}
\arguments{
\item{obj}{A \code{prcomp} object}

\item{type}{Display absolute proportions or cumulative proportion. Possible values:
"pev" or "cev"}

\item{pc_nr}{How many principal components to display max}

\item{title}{Title of the plot}
}
\value{
An object created by \code{ggplot}, which can be assigned and further customized.
}
\description{
Produces a scree plot for investigating the proportion of explained variance, or
alternatively the cumulative value
}
\examples{
dds <- makeExampleDESeqDataSet_multifac(betaSD_condition = 3, betaSD_tissue = 1)
rlt <- DESeq2::rlogTransformation(dds)
pcaobj <- prcomp(t(SummarizedExperiment::assay(rlt)))
pcascree(pcaobj, type = "pev")
pcascree(pcaobj, type = "cev", title = "Cumulative explained proportion of variance - Test dataset")

}
