% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppiEnrichNetwork.R
\name{ppiEnrichNetwork}
\alias{ppiEnrichNetwork}
\title{Test a PPI network for enriched pathways}
\usage{
ppiEnrichNetwork(
  network,
  analysis = "sigora",
  filterResults = "default",
  gpsRepo = "default",
  geneUniverse = NULL
)
}
\arguments{
\item{network}{A "tidygraph" network object, with Ensembl IDs in the first
column of the node table}

\item{analysis}{Default is "sigora", but can also be "reactomepa" or
"hallmark"}

\item{filterResults}{Should the output be filtered for significance? Use
\code{1} to return the unfiltered results, or any number less than 1 for a
custom p-value cutoff. If left as \code{default}, the significance cutoff
for Sigora is 0.001, or 0.05 for ReactomePA and Hallmark.}

\item{gpsRepo}{Only applies to \code{analysis="sigora"}. Gene Pair Signature
object for Sigora to use to test for enriched pathways. Leaving this set
as "default" will use the "reaH" GPS object from \code{Sigora}, or you can
provide your own custom GPS repository.}

\item{geneUniverse}{Only applies when \code{analysis} is "reactomepa" or
"hallmark". The set of background genes to use when testing with ReactomePA
or Hallmark gene sets. For ReactomePA this must be a character vector of
Entrez genes. For Hallmark, it must be Ensembl IDs.}
}
\value{
A "data.frame" (tibble) of enriched pathways, with the following
columns:
\item{pathwayId}{Pathway identifier}
\item{pathwayName}{Pathway name}
\item{pValue}{Nominal p value for the pathway}
\item{pValueAdjusted}{p value corrected for multiple testing}
\item{genes}{Candidate genes, which were DE for the comparison and also in
the pathway}
\item{numCandidateGenes}{Number of candidate genes}
\item{numBgGenes}{Number of background genes for the pathway}
\item{geneRatio}{Ratio of candidate and background genes}
\item{totalGenes}{Number of DE genes which were tested for enriched
pathways}
\item{topLevelPathway}{High level Reactome term which serves to group
similar pathways}
}
\description{
Test a PPI network for enriched pathways
}
\examples{
data("exampleDESeqResults")

exNetwork <- ppiBuildNetwork(
    rnaseqResult=exampleDESeqResults[[1]],
    filterInput=TRUE,
    order="zero"
)

ppiEnrichNetwork(
    network=exNetwork,
    analysis="hallmark"
)

}
\references{
Sigora: \url{https://cran.r-project.org/package=sigora}
ReactomePA: \url{https://www.bioconductor.org/packages/ReactomePA/}
MSigDB/Hallmark: \url{https://www.gsea-msigdb.org/gsea/msigdb/collections.jsp}
}
\seealso{
\url{https://github.com/hancockinformatics/pathlinkR}
}
