% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getScores.R
\name{getScores}
\alias{getScores}
\title{Calculate pathways scores for a dataset}
\usage{
getScores(
  inputData,
  geneSets,
  method = "GSVA",
  labels = NULL,
  cores = 1,
  use.assay = 1,
  ...
)
}
\arguments{
\item{inputData}{Matrix, data frame, ExpressionSet or SummarizedExperiment
with omics data. Feature names must match the gene sets nomenclature. To use
preloaded databases, they must be gene symbols.}

\item{geneSets}{A named list with each gene set,
or the name of one preloaded database (go_bp, go_cc, go_mf, kegg, reactome,
pharmgkb, lincs, ctd, disgenet, hpo, wikipathways, tmod)
or a GeneSetCollection. For using network methods,
a data frame including columns:
"source","target","weight" and "mor" (optional).}

\item{method}{Scoring method: M-Scores, GSVA, ssGSEA, singscore, Plage,
Z-score, AUCell, MDT, MLM, ORA, UDT, ULM, FGSEA, norm_FGSEA, WMEAN,
norm_WMEAN, corr_WMEAN, WSUM, norm_WSUM or corr_WSUM.}

\item{labels}{(Only for M-Scores) Vector with the samples class labels (0 or
"Healthy" for control samples). Optional.}

\item{cores}{Number of cores to be used.}

\item{use.assay}{If SummarizedExperiments are used, the number of the assay 
to extract the data.}

\item{...}{Additional parameters for the scoring functions.}
}
\value{
A list with the results of each of the analyzed regions. For each
region type, a data frame with the results and a list with the probes
associated to each region are generated. In addition, this list also contains
the input methData, pheno and platform objects
}
\description{
Calculate pathways scores for a dataset
}
\examples{
data(pathMEDExampleData)
scoresExample <- getScores(pathMEDExampleData, geneSets = "tmod", 
                             method = "GSVA")
}
\references{
Toro-Domínguez, D. et al (2022). \emph{Scoring personalized
molecular portraits identify Systemic Lupus Erythematosus subtypes and
predict individualized drug responses, symptomatology and
disease progression}
 . Briefings in Bioinformatics. 23(5)
}
\seealso{
\code{\link{trainModel}}
}
\author{
Jordi Martorell-Marugán, \email{jordi.martorell@genyo.es}

Daniel Toro-Dominguez, \email{danieltorodominguez@gmail.com}
}
