% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ora.R
\name{plot_ora}
\alias{plot_ora}
\title{Scatter plot of Over-Representation Analysis results}
\usage{
plot_ora(
  ora,
  pattern = NULL,
  paired = FALSE,
  plotly = FALSE,
  cutoff = 0.05,
  lines = TRUE,
  colors = c("darkgray", "purple", "lightblue", "maroon")
)
}
\arguments{
\item{ora}{Output of \code{\link[pairedGSEA:paired_ora]{paired_ora}}}

\item{pattern}{Highlight pathways containing a specific regex pattern}

\item{paired}{(Default: TRUE) New plotting mode for paired ora analysis}

\item{plotly}{(Default: \code{FALSE})
Logical on whether to return plot as an
interactive \code{\link[plotly:ggplotly]{plotly}} plot or a simple ggplot.}

\item{cutoff}{(Default: \code{0.2}) Adjusted p-value cutoff for
pathways to include}

\item{lines}{(Default: \code{TRUE}) Whether to show dashed lines}

\item{colors}{(Default: \code{c("darkgray", "purple", "navy")})
Colors to use in plot. The colors are ordered as "Both", "DGS", and "DGE"}
}
\value{
A ggplot
}
\description{
Scatter plot of Over-Representation Analysis results
}
\note{
suggestion: importFrom plotly ggplotly
}
\examples{
data(example_ora_results)

plot_ora(example_ora_results)
}
\concept{plotting}
