% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readBlast.R
\name{readBlast}
\alias{readBlast}
\title{Convert NCBI BLAST+ Files to Dataframe}
\usage{
readBlast(
  file,
  minE = 1,
  length = 0,
  identity = 0,
  removeExactMatches = FALSE,
  scope = NULL,
  packMatches = NULL
)
}
\arguments{
\item{file}{The file path of the blast file.}

\item{minE}{Blast results with e values greater than
the specified cutoff will be ignored.}

\item{length}{Blast results alignment lengths lower below
this value will be ignored}

\item{identity}{Blast results with target sequence identities below
this value will be ignored.}

\item{removeExactMatches}{If true, matches with 100% sequence identity will 
be ignored to prevent self-hits.}

\item{scope}{If specified, blast results below the specified value
will be ignored. Note that the dataframe of transposon
matches must also be supplied to calculate scope. Scope is 
the proportion of the transposon's internal sequence 
occupied by the BLAST hit.}

\item{packMatches}{taframe containing genomic ranges and names referring 
to sequences to be extracted. Can be obtained from 
\code{\link{packSearch}} or generated from a 
\code{\link[GenomicRanges:GRanges-class]{GRanges}} object, 
after conversion to a dataframe. Must contain the 
following features:
\itemize{
    \item start - the predicted element's start base 
    sequence position.
    \item end - the predicted element's end 
    base sequence position.
    \item seqnames - character string 
    referring to the sequence name in \code{Genome} to 
    which \code{start} and \code{end} refer to.
}}
}
\value{
A dataframe containing the converted .blast6out file. 
The file contains the following features:
\itemize{
    \item Query sequence ID
    \item Target sequence ID
    \item Percenty sequence identity
    \item Alignment length
    \item Number of mismatches
    \item Number of gaps
    \item Base position of alignment start 
    in query sequence
    \item Base position of alignment end in query sequence
    \item Base position of alignment start in target sequence
    \item Base position of alignment end in target sequence
    \item E-value
    \item Bit score
}
}
\description{
Reads .blast6out files (NCBI Blast Format) generated by 
the VSEARCH clustering and alignment algorithms.
}
\details{
blast6out file is tab-separated text file compatible with 
NCBI BLAST m8 and NCBI BLAST+ outfmt 6 formats. One 
cluster/alignment can be found for each line.
}
\examples{
readBlast(system.file(
    "extdata", 
    "packMatches.blast6out", 
    package = "packFinder"
))

}
\references{
For further information, see the NCBI BLAST+ application
documentation and help pages 
(https://www.ncbi.nlm.nih.gov/pubmed/20003500?dopt=Citation).
VSEARCH may be downloaded from 
\url{https://github.com/torognes/vsearch}; see 
\url{https://www.ncbi.nlm.nih.gov/pubmed/27781170} 
for further information.
}
\seealso{
code{\link{blastAnalysis}}, code{\link{blastAnnotate}},
code{\link{packAlign}}, 
code{\link{readUc}}, code{\link{packClust}}
}
\author{
Jack Gisby
}
