% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_benchmark.R
\name{run_benchmark}
\alias{run_benchmark}
\title{Run benchmark tests}
\usage{
run_benchmark(
  species,
  method_list = c("homologene", "gprofiler", "babelgene"),
  run_convert_orthologs = TRUE,
  remove_failed_times = FALSE,
  save_path = tempfile(fileext = ".csv"),
  mc.cores = 1,
  force = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{species}{Species names.}

\item{method_list}{A list of ortholog conversion methods to benchmark.}

\item{run_convert_orthologs}{Benchmark
\link[orthogene]{convert_orthologs} function.}

\item{remove_failed_times}{In instances where
no genes were returned, set time to \code{NA}.}

\item{save_path}{Path to save results to.}

\item{mc.cores}{Number of cores to parallelise species across.}

\item{force}{Force regeneration of files even if cached files exist.
Set to TRUE or 1 to just force regenerating the \code{convert_orthologs} step.
Set to 2 to force regenerating both the \code{convert_orthologs} and 
\code{all_genes} steps.}

\item{verbose}{Print messages.}
}
\value{
\code{data.table} with benchmark results
}
\description{
Runs benchmarks tests on \link[orthogene]{all_genes} and
 \link[orthogene]{convert_orthologs} across multiple species,
 using multiple methods ("homologene", and "gprofiler").
}
\keyword{internal}
