% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_orthotree.R
\name{plot_orthotree}
\alias{plot_orthotree}
\title{Create a phylogenetic tree of shared orthologs}
\source{
\href{https://yulab-smu.top/treedata-book/chapter8.html#phylopic}{
ggtree tutorial}
}
\usage{
plot_orthotree(
  tree = NULL,
  orth_report = NULL,
  species = NULL,
  method = c("babelgene", "homologene", "gprofiler"),
  tree_source = "timetree",
  non121_strategy = "drop_both_species",
  reference_species = "human",
  clades = list(Primates = c("Homo sapiens", "Macaca mulatta"), Eutherians =
    c("Homo sapiens", "Mus musculus", "Bos taurus"), Mammals = c("Homo sapiens",
    "Mus musculus", "Bos taurus", "Ornithorhynchus anatinus", "Monodelphis domestica"),
    Tetrapods = c("Homo sapiens", "Mus musculus", "Gallus gallus", "Anolis carolinensis",
    "Xenopus tropicalis"), Vertebrates = c("Homo sapiens", "Mus musculus",
    "Gallus gallus", "Anolis carolinensis", "Xenopus tropicalis", "Danio rerio"),
    Invertebrates = c("Drosophila melanogaster", 
     "Caenorhabditis elegans")),
  clades_rotate = list(),
  scaling_factor = NULL,
  show_plot = TRUE,
  save_paths = c(tempfile(fileext = ".ggtree.pdf"), tempfile(fileext = ".ggtree.png")),
  width = 15,
  height = width,
  mc.cores = 1,
  verbose = TRUE
)
}
\arguments{
\item{tree}{A phylogenetic tree of class \link[ape]{phylo}. If no tree 
is provided (\code{NULL}) a 100-way multiz tree will be imported from  
\href{http://hgdownload.soe.ucsc.edu/goldenPath/hg38/multiz100way}{
UCSC Genome Browser}.}

\item{orth_report}{An ortholog report from one or more species 
generated by \link[orthogene]{report_orthologs}.}

\item{species}{Species to include in the final plot.
If \code{NULL}, then all species from the given database (\code{method}) 
will be included (via \link[orthogene]{map_species}), 
so long as they also exist in the \code{tree}.}

\item{method}{R package to use for gene mapping:
\describe{
 \item{\code{"gprofiler"}}{Slower but more species and genes.}
 \item{\code{"homologene"}}{Faster but fewer species and genes.}
 \item{\code{"babelgene"}}{Faster but fewer species and genes.
 Also gives consensus scores for each gene mapping based on a
 several different data sources.}
}}

\item{tree_source}{Can be one of the following:
\describe{
\item{"timetree2022":\cr}{Import and prune the
\href{https://doi.org/10.1093/molbev/msac174}{
TimeTree >147k species} phylogenetic tree. Can also simply type "timetree".}
\item{"timetree2015":\cr}{Import and prune the
\href{http://www.timetree.org/public/data/TimetreeOfLife2015.nwk}{
TimeTree >50k species} phylogenetic tree.}
\item{"OmaDB":\cr}{Construct a tree from \href{omabrowser.org}{OMA} 
(Orthologous Matrix browser) via the \link[OmaDB]{getTaxonomy} function.
\emph{NOTE: } Does not contain branch lengths,
 and therefore may have limited utility.}
\item{"UCSC":\cr}{Import and prune the 
\href{https://hgdownload.soe.ucsc.edu/goldenPath/hg38/multiz100way/}{
UCSC 100-way alignment} phylogenetic tree (hg38 version).}
\item{"<path>":\cr}{Read a tree from a newick text file 
from a local or remote URL using \link[ape]{read.tree}.}  
}}

\item{non121_strategy}{How to handle genes that don't have
1:1 mappings between \code{input_species}:\code{output_species}.
Options include:\cr
\describe{
\item{\code{"drop_both_species" or "dbs" or 1}}{
Drop genes that have duplicate
mappings in either the \code{input_species} or \code{output_species}
(\emph{DEFAULT}).}
\item{\code{"drop_input_species" or "dis" or 2}}{
Only drop genes that have duplicate
mappings in the \code{input_species}.}
\item{\code{"drop_output_species" or "dos" or 3}}{
Only drop genes that have duplicate
mappings in the \code{output_species}.}
\item{\code{"keep_both_species" or "kbs" or 4}}{
Keep all genes regardless of whether
they have duplicate mappings in either species.}
\item{\code{"keep_popular" or "kp" or 5}}{
Return only the most "popular" interspecies ortholog mappings.
 This procedure tends to yield a greater number of returned genes
 but at the cost of many of them not being true biological 1:1 orthologs.}
 \item{\code{"sum","mean","median","min" or "max"}}{
 When \code{gene_df} is a matrix and \code{gene_output="rownames"},
  these options will aggregate many-to-one gene mappings
  (\code{input_species}-to-\code{output_species})
  after dropping any duplicate genes in the \code{output_species}.
 }
}}

\item{reference_species}{Reference species.}

\item{clades}{A named list of clades each containing 
a character vector of species used to define the respective clade 
using \link[ggtree]{MRCA}.}

\item{clades_rotate}{A list of clades to rotate (via \link[ape]{rotate}), 
each containing a character vector of species used to define the respective
 clade using \link[ggtree]{MRCA}.}

\item{scaling_factor}{How much to scale y-axis parameters (e.g. offset) by.}

\item{show_plot}{Whether to print the final tree plot.}

\item{save_paths}{Paths to save plot to.}

\item{width}{Saved plot width.}

\item{height}{Saved plot height.}

\item{mc.cores}{Number of cores to parallelise different steps with.}

\item{verbose}{Print messages.}
}
\value{
A list containing:  
\describe{
\item{plot : }{Annotated ggtree object.}
\item{tree : }{The pruned, standardised phylogenetic tree used in the plot.}
\item{orth_report : }{Ortholog reports for each \code{species} against
 the \code{reference_species}}.
\item{metadata : }{Metadata used in the plot,
 including silhouette PNG ids from \href{http://phylopic.org/}{phylopic}.}
\item{clades : }{Metadata used for highlighting clades.}
\item{method : }{\code{method} used.}
\item{reference_species : }{\code{reference_species} used.}
\item{save_paths : }{\code{save_paths} to plot.}
}
}
\description{
Automatically creates a phylogenetic tree plot annotated with metadata
describing how many orthologous genes each species shares with the
 \code{reference_species} ("human" by default).
}
\examples{
if(require("ape")){
 suppressWarnings(
  orthotree <- plot_orthotree(species = c("human","monkey","mouse"))
 )
}
}
