% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_orthologs_babelgene.R
\name{map_orthologs_babelgene}
\alias{map_orthologs_babelgene}
\title{Map orthologs: babelgene}
\source{
\href{https://cran.r-project.org/web/packages/babelgene/vignettes/babelgene-intro.html}{
babelgene tutorial}
}
\usage{
map_orthologs_babelgene(
  genes,
  input_species,
  output_species = "human",
  min_support = 1,
  top = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{genes}{Gene list.}

\item{input_species}{Name of the input species (e.g., "mouse","fly").
Use \link[orthogene]{map_species} to return a full list
of available species.}

\item{output_species}{Name of the output species (e.g. "human","chicken").
Use \link[orthogene]{map_species} to return a full list
 of available species.}

\item{min_support}{Minimum number of supporting source databases. Gene pairs available in this package are supported by 2 to 12 databases (the maximum varies depending on the species).}

\item{top}{For each gene, output only the match with the highest support level if there are multiple hits.}

\item{verbose}{Print messages.}

\item{...}{Additional arguments to be passed to
\link[gprofiler2]{gorth} or \link[homologene]{homologene}.\cr\cr
\emph{NOTE}: To return only the most "popular"
interspecies ortholog mappings,
supply \code{mthreshold=1} here AND set \code{method="gprofiler"} above.
This procedure tends to yield a greater number of returned genes but at
 the cost of many of them not being true biological 1:1 orthologs.\cr\cr
 For more details, please see
\href{https://cran.r-project.org/web/packages/gprofiler2/vignettes/gprofiler2.html}{
 here}.}
}
\value{
Ortholog map \code{data.frame}
}
\description{
Map orthologs from one species to another
using \link[babelgene]{orthologs}.
}
\keyword{internal}
