% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dMcast.R
\name{dMcast}
\alias{dMcast}
\title{dMcast}
\source{
\code{ 
groupings <- data.frame(A = as.factor(sample(1e4,1e6,TRUE)))
formula <- stats::as.formula("~0+.")
dm <- orthogene:::dMcast(data = groupings, formula = formula)
}
}
\usage{
dMcast(
  data,
  formula,
  value.var = NULL,
  as.factors = FALSE,
  na.action = stats::na.pass,
  factor.nas = TRUE,
  drop.unused.levels = TRUE
)
}
\arguments{
\item{data}{A \link[base]{data.frame}.}

\item{formula}{Casting \link[stats]{formula}, 
see details for specifics.}

\item{value.var}{Name of column that stores values to be aggregated numerics.}

\item{as.factors}{If \code{TRUE}, treat all columns as factors, including}

\item{factor.nas}{If \code{TRUE}, treat factors with NAs as new levels. 
Otherwise, rows with NAs will receive zeroes in all columns for that factor.}

\item{drop.unused.levels}{Should factors have unused levels dropped?
Defaults to \code{TRUE}, in contrast to \code{model.matrix}}
}
\value{
matrix
}
\description{
Reimplementation of function that originally part of the R package
\code{Matrix.utils} before the package was 
\href{https://cran.r-project.org/web/packages/Matrix.utils/index.html}{
deprecated}. The only difference is that this version of \code{dMcast} does
not include an aggregation feature at the end.
}
\keyword{internal}
