% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/con_primer_coverage.R
\name{mismatch.mutation.check}
\alias{mismatch.mutation.check}
\title{Identification of Mutations Induced by Mismatch Binding Events.}
\usage{
mismatch.mutation.check(
  primer.df,
  template.df,
  mutation.types = c("stop_codon", "substitution")
)
}
\arguments{
\item{primer.df}{A \code{Primers} object.}

\item{template.df}{A \code{Template} object.}

\item{mutation.types}{Character vector of the mutation types to be checked for.}
}
\value{
A list containing data frames where an entry of 1 is present if the \code{primer.seq} induces a mutation that is
forbidden according to the provided \code{mutation.types}, otherwise 0.
}
\description{
Identifies whether mutations are induced by mismatch binding events.
}
\details{
Checks for one primer and all covered templates whether any templates are bound
with mismatches such that mismatches are induced. A numeric vector indicating 
which binding events induce a forbidden mismatch according to 
\code{mutation.types} is returned such that \code{1} indicates forbidden events
and \code{0} allowed events.
}
\keyword{internal}
