% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SettingsDoc.R, R/constraints.R, R/settings.R
\docType{class}
\name{Settings}
\alias{Settings}
\alias{ConstraintSettings}
\alias{ConstraintSettings-class}
\alias{CoverageConstraints}
\alias{CoverageConstraints-class}
\alias{ConstraintOptions}
\alias{ConstraintOptions-class}
\alias{PCR_Conditions}
\alias{PCR_Conditions-class}
\alias{DesignSettings}
\alias{DesignSettings-class}
\alias{constraints}
\alias{constraints,DesignSettings-method}
\alias{constraints,AbstractConstraintSettings-method}
\alias{cvg_constraints}
\alias{cvg_constraints,DesignSettings-method}
\alias{PCR}
\alias{PCR,DesignSettings-method}
\alias{conOptions}
\alias{conOptions,DesignSettings-method}
\alias{constraintLimits}
\alias{constraintLimits,DesignSettings-method}
\alias{constraints<-}
\alias{constraints<-,DesignSettings,list-method}
\alias{constraints<-,AbstractConstraintSettings,list-method}
\alias{cvg_constraints<-}
\alias{cvg_constraints<-,DesignSettings-method}
\alias{constraintLimits<-}
\alias{constraintLimits<-,DesignSettings-method}
\alias{PCR<-}
\alias{PCR<-,DesignSettings-method}
\alias{conOptions<-}
\alias{conOptions<-,DesignSettings-method}
\alias{parallel_setup}
\title{Settings Functionalities.}
\usage{
constraints(x)

\S4method{constraints}{DesignSettings}(x)

\S4method{constraints}{AbstractConstraintSettings}(x)

cvg_constraints(x)

\S4method{cvg_constraints}{DesignSettings}(x)

PCR(x)

\S4method{PCR}{DesignSettings}(x)

conOptions(x)

\S4method{conOptions}{DesignSettings}(x)

constraintLimits(x)

\S4method{constraintLimits}{DesignSettings}(x)

constraints(x) <- value

\S4method{constraints}{DesignSettings,list}(x) <- value

\S4method{constraints}{AbstractConstraintSettings,list}(x) <- value

cvg_constraints(x) <- value

\S4method{cvg_constraints}{DesignSettings}(x) <- value

constraintLimits(x) <- value

\S4method{constraintLimits}{DesignSettings}(x) <- value

PCR(x) <- value

\S4method{PCR}{DesignSettings}(x) <- value

conOptions(x) <- value

\S4method{conOptions}{DesignSettings}(x) <- value

parallel_setup(cores = NULL)
}
\arguments{
\item{x}{A \code{DesignSettings} object.}

\item{value}{An object to be used in one of the setters.
For \code{constraints<-} and \code{constraintLimits<-}, a list with constraint settings or boundaries. Each list entry
should have a permissible name and consist of at most two
values providing the minimal and/or maximal allowed values, which
have to be denominated via \code{min} and \code{max}.

For \code{conOptions<-}, a list with constraint options. The permissible
fields of the list and their types are documented in the 
\code{\link{ConstraintOptions}} class.

For \code{cvg_constraints<-}, a list with coverage constraints. Each
list entry must have a permissible name and
contain a numeric vector with at most two components
describing the minimal and/or maximal required values that
are to be indicated via \code{min} and \code{max}.
The permissible contraint identifiers are documented in the
\code{\link{CoverageConstraints}} class.

For \code{PCR<-}, a named list providing PCR conditions 
The permissible fields of the list and their types
are documented in the \code{\link{PCR_Conditions}} class.}

\item{cores}{A numeric providing the number of cores to use. The default is \code{NULL}
such that half the number of available cores are used.}
}
\value{
The \code{ConstraintSettings} constructor defines a new
\code{ConstraintSettings} object.

The \code{CoverageConstraints} constructor initializes a new
\code{CoverageConstraints} object.

The \code{ConstraintOptions} constructor returns
a new \code{ConstraintOptions} object.

The \code{PCR_Conditions} constructor defines a new \code{PCR_Conditions} object.

The \code{DesignSettings} constructor defines a \code{DesignSettings} object.

\code{constraints} gets a list with the active constraint settings.

\code{cvg_constraints} returns the list of active coverage constraints.

\code{PCR} gets the list of PCR conditions defined in the
provided \code{DesignSettings} object.

\code{conOptions} returns a list with constraint options.

\code{constraintLimits} gets the list of constraint limits.

\code{constraints<-} sets the list of constraints in a \code{DesignSettings} object.

\code{cvg_constraints<-} sets the list of coverage constraints in the provided \code{DesignSettings} object.

\code{constraintLimits<-} sets the list of constraint limits in 
the provided \code{DesignSettings} object.

\code{PCR<-} sets the constraint options in the provided
\code{DesignSettings} object.

\code{conOptions<-} sets the specified list of constraint options in the provided \code{DesignSettings} object.

\code{parallel_setup} returns \code{NULL}.
}
\description{
\describe{
\item{\code{DesignSettings}}{The \code{DesignSettings} class encapsulates all settings 
for designing and evaluating primer sets. 
Upon loading an XML file, the \code{DesignSettings} class checks whether
the defined constraints can be applied by identifying whether 
the requirements for external programs are fulfilled. 
If the requirements are not fulfilled, the affected constraints 
are removed from the loaded \code{DesignSettings} object
and a warning is issued.
The loaded constraints are automatically ordered according to
the option \code{openPrimeR.constraint_order} such that 
the runtime of the \code{\link{design_primers}} and \code{\link{filter_primers}}
functions is optimized.}
\item{\code{constraints}}{Gets the active constraints of the provided
\code{DesignSettings} object.}
\item{\code{constraints<-}}{Sets the active constraints of the provided
\code{DesignSettings} object.}
\item{\code{cvg_constraints}}{Gets the coverage constraints of the provided
\code{DesignSettings} object.}
\item{\code{cvg_constraints<-}}{Sets the coverage constraints of the provided
\code{DesignSettings} object.}
\item{\code{conOptions}}{Gets the constraint settings of the provided 
\code{DesignSettings} object.}
\item{\code{conOptions<-}}{Sets the constraint settings of the provided
\code{DesignSettings} object.}
\item{\code{constraintLimits}}{Gets the constraint limits that are defined in the provided 
\code{DesignSettings} object.}
\item{\code{constraintLimits<-}}{Sets the constraint limits of the provided 
\code{DesignSettings} object.}
\item{\code{PCR}}{Gets the PCR conditions that are defined in the provided
\code{DesignSettings} object.}
\item{\code{PCR<-}}{Sets the PCR conditions that are defined in the provided
\code{DesignSettings} object.}
\item{\code{ConstraintSettings}}{The \code{ConstraintSettings} class encapsulates the constraints
on the physicochemical properties of primers.}
\item{\code{CoverageConstraints}}{The \code{CoverageConstraints} class encapsulates the conditions
under which the coverage of primers is evaluated.}
\item{\code{PCR_Conditions}}{The \code{PCR_Conditions} class encapsulates the PCR conditions
for the computation of primer properties.}
\item{\code{ConstraintOptions}}{The \code{ConstraintOptions} class encapsulates the options
for constraint computations.}
\item{\code{parallel_setup}}{Registers the specified number of cores
with the parallel backend.}
}
}
\details{
Note that for the \code{DesignSettings} class, the fields \code{Input_Constraints}, \code{Input_Constraint_Boundaries}, and \code{Coverage_Constraints} should 
contain entries with at most two components using the fields \code{min} and/or \code{max}.
The \code{Input_Constraint_Boundaries} should always be at least as general as the
specified \code{Input_Constraints}.

For an overview of permissible constraints,
please consider the \code{\link{ConstraintSettings}} documentation.
}
\section{Slots}{

\describe{
\item{\code{Input_Constraints}}{A \code{\link{ConstraintSettings}} object specifying the 
desired target value ranges for primer properties.}

\item{\code{Input_Constraint_Boundaries}}{A \code{\link{ConstraintSettings}} object specifying
the limits for relaxing the constraints during the primer design procedure.
This slot may contain the same fields as the \code{Input_Constraints} slot,
but the specified desired ranges should be at least as general as
those specified in the \code{Input_Constraints} slot.}

\item{\code{Coverage_Constraints}}{A \code{\link{CoverageConstraints}} object specifying
the constraints for computing the primer coverage.}

\item{\code{PCR_conditions}}{A \code{\link{PCR_Conditions}} object specifying the PCR-related settings.}

\item{\code{constraint_settings}}{A \code{\link{ConstraintSettings}} object providing options 
for the computation of individual physicochemical properties.}

\item{\code{status}}{Named boolean vector indicating 
which of the possible constraints are active (\code{TRUE})
and which are not (\code{FALSE}).}

\item{\code{settings}}{For \code{ConstraintSettings}, a named list containing the settings for
the active constraints.
The list may contain the following fields:
\describe{
\item{primer_coverage:}{The required number of covered template sequences per primer.}
\item{primer_specificity:}{The required required specificity of 
                           primers in terms of a ratio in the interval [0,1].}
\item{primer_length:}{The required lengths of primer sequences.}
\item{gc_clamp:}{The desired number of GCs at primer 3' termini.}
\item{gc_ratio:}{The desired ratio of GCs in primers 
                 in terms of numbers in the interval [0,1].}
\item{no_runs:}{The accepted length homopolymer runs in a primer.}
\item{no_repeats:}{The accepted length of dinucleotide repeats in a primer.}
\item{self_dimerization:}{The lowest acceptable free energy [kcal/mol] for the 
                          interaction of a primer with itself. The identification
                           of self dimers requires the software \emph{OligoArrayAux} (see notes).}
\item{melting_temp_range:}{The desired melting temperature (Celsius) of primers.
                          The accurate computation of melting temperatures requires the software \emph{MELTING} (see notes).}
\item{melting_temp_diff:}{The maximal allowed difference between the melting temperatures (Celsius)
                          of primers contained in the same set. The accurate computation of melting temperatures
                          requires the software \emph{MELTING} (see notes).}
\item{cross_dimerization:}{The lowest acceptable free energy [kcal/mol] for the
                           interaction of a primer with another primer. The identification
                           of cross dimers requires the software \emph{OligoArrayAux} (see notes).}
\item{secondary_structure:}{The lowest acceptable free energy [kcal/mol] for the
                            formation of primer secondary structures. Secondary structures are determined
                            using the software \emph{ViennaRNA} (see notes).}
}

For \code{PCR_Conditions}, a named list with PCR conditions.
The following fields are possible: 
\describe{
\item{\code{use_taq_polymerase}:}{A logical identifying whether you are performing PCR with a Taq polymerase (\code{TRUE}) or not (\code{FALSE}).}
\item{\code{annealing_temp}:}{The annealing temperature in Celsius that is to be used for evaluating the
constraints defined in the \code{\link{ConstraintSettings}} object.
If the annealing temperature field
is not provided, a suitable annealing temperature is automatically computed using a rule of thumb (i.e. subtracting 5 from the melting temperature).}
\item{\code{Na_concentration}:}{The molar concentration of monovalent sodium ions.}
\item{\code{Mg_concentration}:}{The molar concentration of divalent magnesium ions.}
\item{\code{K_concentration}:}{The molar concentration of monovalent potassium ions.}
\item{\code{Tris_concentration}:}{The molar concentration of the Tris(hydroxymethyl)-aminomethan buffer.}
\item{\code{primer_concentration}:}{The molar concentration of the PCR primers.}
\item{\code{template_concentration}:}{The molar concentration of the PCR templates.}
}

For \code{CoverageConstraints}, a named list with constraint options. Each 
list entry should have an entry \code{min} and/or \code{max}
in order to indicate the minimal and maximal allowed values,
respectively. 
The following identifiers can be used as coverage constraints:
\describe{
\item{\code{primer_efficiency}:}{The desired efficiencies of primer-template amplification events 
in order to be considered as \emph{covered}. \code{primer_efficiency} provides a value in the interval [0,1],
which is based on \pkg{DECIPHER}'s thermodynamic model, which considers the impact of 3' terminal mismatches.}
\item{\code{annealing_DeltaG}:}{The desired free energies of annealing for putative
coverage events between primers and templates. Typically, one would 
limit the maximally allowed free energy.}
\item{\code{stop_codon}:}{Whether coverage events introducing
stop codons into the amplicons should be allowed or discarded. 
Here, a value of \code{1} indicates coverage events that induce stop codons.
As such, setting both minimum and maximium to zero will disregard
coverage events inducing stop codons, while setting the minimum to zero
and the maximum to 1 will allow coverage events that induce stop codons.}
\item{\code{substitution}:}{Whether coverage events introducing
substitutions into the amino acid sequence are considered or discarded.
The same encoding as for \code{stop_codon} is used, that is,
the value \code{1} indicates coverage events
inducing substitutions. Hence, to prevent substitutions,
the maximal value of \code{substitution} can be set to zero.}
\item{\code{terminal_mismatch_pos}:}{The position relative to 
the primer 3' terminal end for which mismatch binding events should be allowed,
where the last base in a primer is indicated by position \code{1}.
For example, setting the minimal value of \code{terminal_mismatch_pos} 
to \code{7} means that only coverage events that do not have a terminal mismatch
within the last 6 bases of the primer are allowed.}
\item{\code{coverage_model}:}{Use a logistic regression model combining the free energy of annealing and 3' terminal mismatch positions
to determine the expected rate of false positive coverage calls. 
Using \code{coverage_model}, you can specify the allowed ratio of falsely predicted coverage events.
Typically, one would limit the maximal allowed rate of false positives. Note that setting a
small false positive rate will reduce the sensitivity of the coverage calls (i.e. true positives will be missed).}
}

For \code{ConstraintOptions}, a named list with constraint options.
The following fields are permissible:
\describe{
\item{allowed_mismatches:}{The maximal number of allowed mismatches between
a primer and a template sequence. If the number of mismatches of a primer
with a template exceeds the specified value, the primer is not considered
to cover the corresponding template when the coverage is being computed.}
\item{allowed_other_binding_ratio:}{Ratio of allowed binding events
outside the target binding ratio. This value should be in the interval
[0,1]. If the specified value is greater than zero, all coverage events
outside the primer binding region are reported. If, however, the
identified ratio of off-target events should exceed the allowed ratio,
a warning is issued. If \code{allowed_other_binding_ratio} is set to \code{0},
only on-target primer binding events are reported.
The setting of \code{allowed_other_binding_ratio} is ignored when designing primers, 
which always uses a value of 0.}
\item{allowed_region_definition:}{The definition of the target
binding regions that is used for evaluating the coverage.
In case that \code{allowed_region_definition} is \code{within}, primers have to lie within the allowed binding region.
If \code{allowed_region_definition} is \code{any}, primers only have to overlap with the target binding region.}
\item{hexamer_coverage:}{If \code{hexamer_coverage} is set to "active", primers whose 3' hexamer (the last 6 bases) is fully complementary to the corresponding
template region are automatically considered to cover the template. 
If \code{hexamer_coverage} is set to \code{inactive}, 
hexamer complementarity does not guarantee template coverage.}
}}
}}

\note{
The following external programs are required for constraint computations:
\describe{
\item{MELTING (http://www.ebi.ac.uk/biomodels/tools/melting/):}{Thermodynamic computations (optional) for determining melting temperatures for the constraints \code{melting_temp_diff} and \code{melting_temp_range}}
\item{OligoArrayAux (http://unafold.rna.albany.edu/OligoArrayAux.php):}{Thermodynamic computations used for computing \code{self_dimerization} and \code{cross_dimerization}.
Also required for computing \code{primer_coverage} when a constraint based on the free energy of annealing is active.}
\item{ViennaRNA (http://www.tbi.univie.ac.at/RNA/):}{Secondary structure predictions used for the constraint \code{secondary_structure}}
}

The following external programs are required for computing the coverage constraints:
\describe{
\item{OligoArrayAux (http://unafold.rna.albany.edu/OligoArrayAux.php):}{Thermodynamic computations used for 
computing the coverage constraints \code{annealing_DeltaG}, \code{primer_efficiency}, and \code{coverage_model}}
}
}
\section{primer_coverage}{

Computing the primer coverage involves identifying
which templates are expected to be amplified (covered) by which primers.
The \code{primer_coverage} constraint
determines the minimal and maximal number of coverage events per primer
that are required. The computation of primer coverage is governed
by the coverage constraints postulated via \code{\link{CoverageConstraints}}
and the constraint options defined via \code{\link{ConstraintOptions}}.
}

\section{primer_specificity}{

Primer specificity is automatically determined during the primer coverage
computations but the constraint is only checked when the \code{primer_specificity}
field is available. The specificity of a primer is defined as its ratio of
on-target vs total coverage events (including off-target coverage). Low-specificity
primers should be excluded as they may not amplify the target region effectively.
}

\section{primer_length}{

The length of a primer is defined by its number of bases. Typical
primers have lengths between 18 and 22. Longer primers may guarantee higher
specificities.
}

\section{gc_clamp}{

The GC clamp refers to the presence of GCs at the 3' end of a primer.
For the \code{gc_clamp} constraint, we consider the number of 3' terminal GCs.
For example, the primer \emph{actgaaatttcaccg} has a GC clamp of length 3.
The presence of a GC clamp is supposed to aid the stability of the
polymerase complex. At the same time, long GC clamps should be avoided.
}

\section{no_runs}{

Homopolymer runs (e.g. the primer \emph{aaaaa} has a run of 5 A's)
may lead to secondary structure formation and unspecific binding
and should therefore be avoided.
}

\section{no_repeats}{

Dinucleotide repeats (e.g. the primer \emph{tatata} has 3 TA repeats)
should be avoided for the same reason a long homopolymer runs.
}

\section{self_dimerization}{

Self dimerization refers to a primer that binds to itself rather than
to one of the templates. Primers exhibiting self dimers should
be avoided as they may prevent the primer from amplifying the templates.
Therefore primers with small free energies of dimerization should 
be avoided.
}

\section{melting_temp_range}{

The melting temperature is the temperature at which 50% of the primers
are in duplex with templates and 50% are still present as random coils.
Hence, primers exhibiting high melting temperatures have high affinities
to the templates, while primers with small melting temperatures
have small affinities. The melting temperatures of the primers
determine the annealing temperature of the PCR, which is why
the melting temperatures of the primers should not deviate too much (see
\code{melting_temp_diff}).
}

\section{melting_temp_diff}{

The differences between the melting temperatures of primers in a
set of primers should not deviate too much as the annealing temperaturte
of a PCR should be based on the smallest melting temperature
of a primer in the set. If there are other primers in the set 
exhibiting considerably higher melting temperatures,
these primers may bind inspecifically due to the low annealing temperature.
}

\section{cross_dimerization}{

When two different primers bind to each each other rather than
to the templates, this is called cross dimerization.
Cross dimerization should be prevent at all costs because
such primers cannot effectively amplify their target templates.
Cross dimerizing primers can be excluding primers
exhibiting small free energies of cross dimerization.
}

\section{secondary_structure}{

When a primer exhibits secondary structure, this may prevent it from
binding to the templates. To prevent this, 
primers with low free energies of secondary structure formation
can be excluded.
}

\examples{

# Initializing a new 'ConstraintSettings' object:
constraint.settings <- new("ConstraintSettings")
# Retrieving the constraint settings from a 'DesignSettings' object:
data(Ippolito) # loads a 'DesignSettings' object into 'settings'
constraints(settings)
# Modifying the constraint settings:
constraints(settings)$no_runs["max"] <- 10
constraints(settings) <- constraints(settings)[names(constraints(settings)) != "gc_clamp"]

# Initialize a new 'CoverageConstraints' object:
cvg.constraints <- new("CoverageConstraints")
# Retrieving the coverage constraints from a 'DesignSettings' object:
data(Ippolito) # loads a 'DesignSettings' object into 'settings'
cvg_constraints(settings)
# Modifying the coverage constraints
cvg_constraints(settings)$primer_efficiency["min"] <- 0.001

# Initialize a new 'ConstraintOptions' object:
constraint.options <- new("ConstraintOptions")
# Retrieve the constraint options from a 'DesignSettings' object:
data(Ippolito) # loads a 'DesignSettings' object into 'settings'
conOptions(settings)
# Prevent off-target binding:
conOptions(settings)$allowed_other_binding_ratio <- 0

# Initialize a new 'PCR_Conditions' object:
PCR.conditions <- new("PCR_Conditions")
# Retrieving the PCR conditions from a 'DesignSettings' object:
data(Ippolito) # loads a 'DesignSettings' object into 'settings'
PCR(settings)
# Modifying the PCR conditions:
PCR(settings)$use_taq_polymerase <- FALSE

# Load a settings object
filename <- system.file("extdata", "settings", 
                 "C_Taq_PCR_high_stringency.xml", package = "openPrimeR")
settings <- read_settings(filename)
# Modify the constraints
constraints(settings)$gc_clamp["min"] <- 0
# Modify the constraint limits for designing primers
constraintLimits(settings)$gc_clamp["max"] <- 6
# Modify the coverage constraints
cvg_constraints(settings)$primer_efficiency["min"] <- 0.001
# Modify the PCR conditions
PCR(settings)$Na_concentration <- 0.0001
# Modify the constraint options
conOptions(settings)$allowed_mismatches <- 0

# Load some settings
data(Ippolito)
# View the active constraints
constraints(settings)
# Require a minimal GC clamp extent of 0
constraints(settings)$gc_clamp["min"] <- 0
# View available constraints
settings

# Load some settings
data(Ippolito)
# View all active coverage constraints
cvg_constraints(settings)
# Increase the maximal false positive rate to increase the sensitiviity of coverage predictions
cvg_constraints(settings)$coverage_model <- c("max" = 0.1) 
# View available coverage constraints:
settings

# Load some settings
data(Ippolito)
# View the active constraint limits
constraintLimits(settings)
# Extend the GC relaxation limit
constraintLimits(settings)$gc_clamp <- c("min" = 0, "max" = 6)
# View available constraints
settings

# Load some settings
data(Ippolito)
# View the active PCR conditions
PCR(settings)
# Evaluate primers with a fixed annealing temperature
PCR(settings)$annealing_temperature <- 50 # celsius
# View available PCR conditions
settings

# Load some settings
data(Ippolito)
# View the active constraint options
conOptions(settings)
# Prevent mismatch binding events
conOptions(settings)$allowed_mismatches <- 0
# View available constraint options
settings
# Use two cores for parallel processing:
parallel_setup(2)
}
\seealso{
\code{\link{read_settings}} for reading settings from XML files,
\code{\link{write_settings}} for storing settings as XML files,
\code{\link{constraints}} for accessing constraints,
\code{\link{constraintLimits}} for accessing constraint boundaries,
\code{\link{cvg_constraints}} for accessing coverage constraints,
\code{\link{conOptions}} for accessing constraint options,
\code{\link{PCR}} for accessing the PCR conditions.
}
\concept{settings functions}
\keyword{Settings}
