% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AnalysisStats.R, R/primers.R,
%   R/plots_comparison.R, R/plots_coverage.R
\name{AnalysisStats}
\alias{AnalysisStats}
\alias{get_cvg_ratio}
\alias{get_comparison_table}
\alias{get_cvg_stats_primer}
\alias{get_cvg_stats}
\title{Primer Analysis Statistics.}
\usage{
get_cvg_ratio(
  primer.df,
  template.df,
  allowed.mismatches = NULL,
  cvg.definition = c("constrained", "basic"),
  mode.directionality = NULL,
  as.char = FALSE
)

get_comparison_table(templates, primers, sample.name = NULL)

get_cvg_stats_primer(
  primer.df,
  template.df,
  cvg.definition = c("constrained", "basic")
)

get_cvg_stats(
  primers,
  templates,
  for.viewing = FALSE,
  total.percentages = FALSE,
  allowed.mismatches = Inf,
  cvg.definition = c("constrained", "basic")
)
}
\arguments{
\item{primer.df}{A \code{Primers} object containing the primers.}

\item{template.df}{A \code{Templates} object containing
the template sequences corresponding to \code{primer.df}.}

\item{allowed.mismatches}{The number of allowed mismatches
for determining the coverage of the templates. By default,
all annotated coverage events are considered.}

\item{cvg.definition}{If \code{cvg.definition} is set to
"constrained", the statistics for the expected
coverage (after applying the coverage constraints) are retrieved.
If \code{cvg.definition} is set to "basic", the coverage is determined 
solely by string matching (i.e. without applying the coverage constraints).
By default, \code{cvg.definition} is set to "constrained".}

\item{mode.directionality}{If \code{mode.directionality} is provided,
the coverage of templates is computed for a specific direction of primers.
Either "fw" (forward coverage only), "rev" (reverse coverage only), or "both" for both directions. By default, \code{mode.directionality} is \code{NULL}
such that the directionality of the primers is determined automatically.}

\item{as.char}{Whether the coverage ratio should
be outputted as a percentage-formatted character vector. By default,
\code{as.char} is set to \code{FALSE} such that a numeric is returned.}

\item{templates}{If \code{primers} is an object of class \code{Primers},
please provide an object of class \code{Templates} containing the
template sequences targeted by \code{primers}. If \code{primers} is a list,
\code{templates} should be a list of \code{Template} objects.}

\item{primers}{To retrieve statistics for a single primer set, 
please provide an object of class \code{Primers} containing a set of
evaluated primers.
To retrieve statistics for multiple primer sets, pelase provide
a list with evaluated \code{Primers} objects.}

\item{sample.name}{Either a single identifier or a character vector 
of identifiers for every
\code{Templates} object in \code{templates}.
By default, \code{sample.name} is \code{NULL} such that the
\code{Run} annotations in the provided \code{Templates} objects are used.}

\item{for.viewing}{Whether the table should be formatted
to be human-readable. By default, \code{for.viewing} is \code{FALSE}.}

\item{total.percentages}{Whether group coverage percentages
should be computed in relation to the total number of template sequences
or in relation to the number of templates belonging to a specific group.
By default, \code{total.percentages} is \code{FALSE} suc that the
percentages are group-specific.}
}
\value{
By default, \code{get_cvg_ratio} returns a numeric providing 
the expected primer coverage ratio.
If \code{as.char} is \code{TRUE}, the output is provided as a
percentage-formatted character vector. 
The attributes \code{no_covered}, \code{no_templates}, 
and \code{covered_templates} provide the number of covered templates, 
the total number of templates, and the IDs of covered templates, respectively.

\code{get_comparison_table} returns a data frame summarizing
the properties of the provided primer data sets.

\code{get_cvg_stats_primer} returns a list with the following entries. \code{cvg_per_nbr_mismatches} contains a data frame listing 
the number of binding events broken down according to the number
of expected mismatches between primers and templates.
\code{cvg_per_group} contains a data frame listing the the coverage
of individual primers per group of templates.

\code{get_cvg_stats} returns a data frame whose entries provide 
the coverage of templates per group of templates.
}
\description{
\describe{
\item{\code{get_cvg_ratio}}{Determines the ratio of template sequences 
that are covered by the evaluated input primers. The ratio
is in the interval [0,1] where 0 indicates 0\% coverage (no templates
covered) and 1 indicates 100\% coverage (all templates covered).}
\item{\code{get_cvg_stats}}{Retrieve statistics on covered templates, 
either for a single or multiple primer sets.}
\item{\code{get_cvg_stats_primer}}{Creates a table summarizing the 
coverage events of individual primers.}
\item{\code{get_comparison_table}}{Creates an overview of the
properties of multiple primer sets by providing
the inter-quartile range of primer properties in bracket notation.}
}
}
\details{
The manner in which \code{get_cvg_ratio} determines the coverage ratio 
depends on the directionality of the input primers.
If either only forward or reverse primers are inputted, the individual
coverage of each primer is used to determine the overall coverage. 
If, however, forward and reverse primers are inputted at the same time, 
the coverage is defined by the intersection of binding events from both,
forward and reverse primers.

For \code{get_cvg_stats_primer}, the cells corresponding
to columns with numeric identifiers 
indicate the percentage of coverage events occurring
with a certain number of mismatches. For example
column \code{3} provides the number of coverage events
where there are exactly three mismatches between primers and templates.
The column \code{Group_Coverage} provides a listing
of the percentage of covered templates per group.
}
\examples{

data(Ippolito)
# Determine the overall coverage
cvg.ratio <- get_cvg_ratio(primer.df, template.df)
# Determine the identitity coverage ratio 
cvg.ratio.0 <- get_cvg_ratio(primer.df, template.df, allowed.mismatches = 0)

# Summarize the properties of multiple primer sets
data(Comparison)
tab <- get_comparison_table(template.data[1:3], primer.data[1:3], "IGH")

data(Ippolito)
# Determine coverage stats per primer
primer.cvg.stats <- get_cvg_stats_primer(primer.df, template.df)

# Coverage statistics for a single primer set
data(Ippolito)
cvg.stats <- get_cvg_stats(primer.df, template.df)
# Coverage statistics for multiple primer sets
data(Comparison)
cvg.stats.comp <- get_cvg_stats(primer.data[1:2], template.data[1:2])
}
