% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clfixer.R
\name{nomenCheckup}
\alias{nomenCheckup}
\title{repair nomenclature mismatches (to curated term set) in a vector of terms}
\usage{
nomenCheckup(cand, namedOffic, n = 1, tagcolname = "tag", ...)
}
\arguments{
\item{cand}{character vector of candidate terms}

\item{namedOffic}{named character vector of curated terms, the names are regarded as tags, intended to be identifiers in curated ontologies}

\item{n}{numeric(1) number of nearest neighbors to return}

\item{tagcolname}{character(1) prefix used to name columns for tags in output}

\item{\dots}{passed to \code{\link[utils]{adist}}}
}
\value{
a data.frame instance with 2n+1 columns (column 1 is candidate,
remaining n pairs of columns are (term, tag) for n nearest neighbors
as measured by \code{adist}.
}
\description{
repair nomenclature mismatches (to curated term set) in a vector of terms
}
\examples{
candidates = c("JHH7", "HUT102", "HS739T", "NCIH716")
# the candidates are cell line names returned in the text dump from
# https://portals.broadinstitute.org/ccle/page?gene=AHR
# note that one must travel to the third nearest neighbor
# to find the match (and tag) for Hs 739.T
# in this example, we compare to cell line names in Cell Line Ontology
nomenCheckup(candidates, cleanCLOnames(), n=3, tagcolname="clo")
}
