% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StoreyBH.R
\name{StoreyBH}
\alias{StoreyBH}
\title{StoreyBH: Offline FDR control using the St-BH procedure}
\usage{
StoreyBH(d, alpha = 0.05, lambda = 0.5)
}
\arguments{
\item{d}{Either a vector of p-values, or a dataframe with the column: p-value
(`pval').}

\item{alpha}{Overall significance level of the FDR procedure, the default is
0.05.}

\item{lambda}{Threshold for Storey-BH, must be between 0 and 1. Defaults to
0.5.}
}
\value{
\item{ordered_d}{ A dataframe with the original data \code{d} and the
  indicator function of discoveries \code{R}. Hypothesis \eqn{i} is rejected
  if the \eqn{i}-th p-value is less than or equal to \eqn{(r/n)\alpha}, where
  \eqn{r} is the rank of the \eqn{i}-th p-value within an ordered set and
  \eqn{n} is the total number of hypotheses. If hypothesis \eqn{i} is
  rejected, \code{R[i] = 1} (otherwise \code{R[i] = 0}).}
}
\description{
Implements the Storey-BH algorithm for offline FDR control, as presented by
Storey (2002).
}
\details{
The function takes as its input either a vector of p-values, or a dataframe
with a column of p-values (`pval').
}
\examples{

pvals <- c(2.90e-08, 0.06743, 0.01514, 0.08174, 0.00171,
        3.60e-05, 0.79149, 0.27201, 0.28295, 7.59e-08,
        0.69274, 0.30443, 0.00136, 0.72342, 0.54757)

StoreyBH(pvals)

}
\references{
Storey, J.D. (2002). A direct approach to false discovery rates.
  \emph{J. R. Statist. Soc. B}: 64, Part 3, 479-498.
}
