% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores.R
\name{score_nlst}
\alias{score_nlst}
\title{Compute the number of LSTs, normalized by the number of WGD events.}
\usage{
score_nlst(segments, n.wgd, kit.coverage, threshold = 15)
}
\arguments{
\item{segments}{A \code{GRanges} object containing the segments, their copy
number and copy number types.}

\item{n.wgd}{Number of whole-genome doubling events (0 if diploid).}

\item{kit.coverage}{A \code{GRanges} object containing the regions covered on
each chromosome arm.}

\item{threshold}{A number above which the test is returned positive (>=).}
}
\value{
A named list with the number of nLSTs and the corresponding label
('Positive', 'Negative').
}
\description{
Compute the number of LSTs, normalized by the number of WGD events.
}
\details{
Compute the number of LSTs in non-LOH segments via the
\code{score_lst} function and subtract the extra noise induced by WGD events:
 nLST = LST - 7*W/2 where W is the number of WGD events.
A sample is HRD positive (deficient in HR pathway) if nLST is greater or
equal to the threshold (15 by default).
This score was linked to BRCA1/2-deficient tumors.
}
\examples{
w <- score_estwgd(segs.chas_example, oncoscan_na33.cov)
score_nlst(segs.chas_example, w['WGD'], oncoscan_na33.cov)
}
