% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module_triselector.R
\name{triselector_ui}
\alias{triselector_ui}
\title{The three-step selector - the ui function}
\usage{
triselector_ui(id, right_margin = "20")
}
\arguments{
\item{id}{id}

\item{right_margin}{margin on the right side, in px. For example, "20" translates to "20px".}
}
\value{
a tagList of UI components
}
\description{
Function should only be used for the developers
}
\examples{
if (interactive()) {
  library(shiny)
  library(Biobase)
  
  file <- system.file("extdata/demo.RDS", package = "omicsViewer")
  dat <- readRDS(file)
  fData <- fData(dat)
  triset <- stringr::str_split_fixed(colnames(fData), '\\\\|', n= 3)
  
  ui <- fluidPage(
    triselector_ui("tres"),
    triselector_ui("tres2")
  )
  server <- function(input, output, session) {
    v1 <- callModule(triselector_module, id = "tres", reactive_x = reactive(triset),
                     reactive_selector1 = reactive("ttest"),
                     reactive_selector2 = reactive("RE_vs_ME"),
                     reactive_selector3 = reactive("mean.diff")
    )
    v2 <- callModule(triselector_module, id = "tres2", reactive_x = reactive(triset),
                     reactive_selector1 = reactive("ttest"),
                     reactive_selector2 = reactive("RE_vs_ME"),
                     reactive_selector3 = reactive("log.fdr"))
    observe({
      print("/////////////////////////")
      print(v1())
    })
  }
  
  shinyApp(ui, server)
}
}
