% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxi_stats.R
\name{fillNA}
\alias{fillNA}
\title{Filling NAs in a matrix using constants calculated from user the defined function}
\usage{
fillNA(
  x,
  maxfill = quantile(x, probs = 0.15, na.rm = TRUE),
  fillingFun = function(x) min(x, na.rm = TRUE) - log10(2)
)
}
\arguments{
\item{x}{a matrix with NA values}

\item{maxfill}{the maximum filled value, if the value calculated by \code{fillingFun} is greater than 
\code{maxfill}, then \code{maxfill} will the used to replace NAs.}

\item{fillingFun}{function to calculate the filling values. It should be a function accept at least one
argument "x", which is a row of input expression matrix. The default is 
\code{function(x) min(x, na.rm = TRUE) - log10(2)} 
corresponds to the "half of lowest detected values" if the expression matrix is log10 transformed.
More examples:#'   
\code{function(x) min(x, na.rm = TRUE) - 1 }# half of lowest detected value when expression matrix
  is in log2 scale
\code{function(x) 0} # replace NA by 0}
}
\value{
a matrix without NAs
}
\description{
This function is usually use to impute missing values in expression matrix, where the rows are
  feature and columns are samples. This function impute the missing values on the row-wise, that is, every 
  row will be imputed using different constant.
}
\note{
The returned matrix may have -Inf, which may need to be filtered/replaced additionally
}
\examples{
m <- matrix(rnorm(200), 20, 10)
m[sample(1:200, size = 20)] <- NA
mf <- fillNA(m)
}
